/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_0.operator.v1.HybridOverlayConfig;
import io.fabric8.openshift.api.model.v5_0.operator.v1.HybridOverlayConfigFluent;
import io.fabric8.openshift.api.model.v5_0.operator.v1.HybridOverlayConfigFluentImpl;
import java.util.Objects;

public class HybridOverlayConfigBuilder
extends HybridOverlayConfigFluentImpl<HybridOverlayConfigBuilder>
implements VisitableBuilder<HybridOverlayConfig, HybridOverlayConfigBuilder> {
    HybridOverlayConfigFluent<?> fluent;
    Boolean validationEnabled;

    public HybridOverlayConfigBuilder() {
        this(true);
    }

    public HybridOverlayConfigBuilder(Boolean validationEnabled) {
        this(new HybridOverlayConfig(), validationEnabled);
    }

    public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HybridOverlayConfig(), validationEnabled);
    }

    public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent, HybridOverlayConfig instance) {
        this(fluent, instance, true);
    }

    public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent, HybridOverlayConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHybridClusterNetwork(instance.getHybridClusterNetwork());
        fluent.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort());
        this.validationEnabled = validationEnabled;
    }

    public HybridOverlayConfigBuilder(HybridOverlayConfig instance) {
        this(instance, (Boolean)true);
    }

    public HybridOverlayConfigBuilder(HybridOverlayConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHybridClusterNetwork(instance.getHybridClusterNetwork());
        this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HybridOverlayConfig build() {
        HybridOverlayConfig buildable = new HybridOverlayConfig(this.fluent.getHybridClusterNetwork(), this.fluent.getHybridOverlayVXLANPort());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HybridOverlayConfigBuilder that = (HybridOverlayConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

