/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0;

import io.fabric8.kubernetes.api.builder.v5_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_0.APIServerSpec;
import io.fabric8.openshift.api.model.v5_0.APIServerSpecFluent;
import io.fabric8.openshift.api.model.v5_0.APIServerSpecFluentImpl;
import java.util.Objects;

public class APIServerSpecBuilder
extends APIServerSpecFluentImpl<APIServerSpecBuilder>
implements VisitableBuilder<APIServerSpec, APIServerSpecBuilder> {
    APIServerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerSpecBuilder() {
        this(true);
    }

    public APIServerSpecBuilder(Boolean validationEnabled) {
        this(new APIServerSpec(), validationEnabled);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIServerSpec(), validationEnabled);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent, APIServerSpec instance) {
        this(fluent, instance, true);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent, APIServerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
        fluent.withAudit(instance.getAudit());
        fluent.withClientCA(instance.getClientCA());
        fluent.withEncryption(instance.getEncryption());
        fluent.withServingCerts(instance.getServingCerts());
        fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile());
        this.validationEnabled = validationEnabled;
    }

    public APIServerSpecBuilder(APIServerSpec instance) {
        this(instance, (Boolean)true);
    }

    public APIServerSpecBuilder(APIServerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
        this.withAudit(instance.getAudit());
        this.withClientCA(instance.getClientCA());
        this.withEncryption(instance.getEncryption());
        this.withServingCerts(instance.getServingCerts());
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIServerSpec build() {
        APIServerSpec buildable = new APIServerSpec(this.fluent.getAdditionalCORSAllowedOrigins(), this.fluent.getAudit(), this.fluent.getClientCA(), this.fluent.getEncryption(), this.fluent.getServingCerts(), this.fluent.getTlsSecurityProfile());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServerSpecBuilder that = (APIServerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

