/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.dsl.internal.uploadable;

import io.fabric8.kubernetes.clnt.v5_0.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v5_0.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v5_0.dsl.internal.uploadable.PodUploadWebSocketListener;
import io.fabric8.kubernetes.clnt.v5_0.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_0.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ObjIntConsumer;
import java.util.zip.GZIPOutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocketListener;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class PodUpload {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECONDS = 10;
    private static final int DEFAULT_COMPLETE_REQUEST_TIMEOUT_SECONDS = 120;
    private static final String TAR_PATH_DELIMITER = "/";

    private PodUpload() {
    }

    public static boolean upload(OkHttpClient client, PodOperationContext context, OperationSupport operationSupport, Path pathToUpload) throws IOException, InterruptedException {
        if (Utils.isNotNullOrEmpty(context.getFile()) && pathToUpload.toFile().isFile()) {
            return PodUpload.uploadFile(client, context, operationSupport, pathToUpload);
        }
        if (Utils.isNotNullOrEmpty(context.getDir()) && pathToUpload.toFile().isDirectory()) {
            return PodUpload.uploadDirectory(client, context, operationSupport, pathToUpload);
        }
        throw new IllegalArgumentException("Provided arguments are not valid (file, directory, path)");
    }

    /*
     * Exception decompiling
     */
    private static boolean uploadFile(OkHttpClient client, PodOperationContext context, OperationSupport operationSupport, Path pathToUpload) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static boolean uploadDirectory(OkHttpClient client, PodOperationContext context, OperationSupport operationSupport, Path pathToUpload) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void copy(InputStream inputStream, ObjIntConsumer<byte[]> consumer) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while (-1 != (n = inputStream.read(buffer))) {
            consumer.accept(buffer, n);
        }
    }

    private static void addFileToTar(String rootTarPath, File file, TarArchiveOutputStream tar) throws IOException {
        String fileName = Optional.ofNullable(rootTarPath).orElse("") + TAR_PATH_DELIMITER + file.getName();
        tar.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file, fileName));
        if (file.isFile()) {
            Files.copy(file.toPath(), (OutputStream)tar);
            tar.closeArchiveEntry();
        } else if (file.isDirectory()) {
            tar.closeArchiveEntry();
            for (File fileInDirectory : file.listFiles()) {
                PodUpload.addFileToTar(fileName, fileInDirectory, tar);
            }
        }
    }

    private static PodUploadWebSocketListener initWebSocket(URL url, OkHttpClient client) {
        PodUploadWebSocketListener podUploadWebSocketListener = new PodUploadWebSocketListener();
        Request.Builder request = new Request.Builder().url(url).header("Sec-WebSocket-Protocol", "v4.channel.k8s.io").get();
        OkHttpClient clone = client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        clone.newWebSocket(request.build(), (WebSocketListener)podUploadWebSocketListener);
        return podUploadWebSocketListener;
    }

    private static URL buildCommandUrl(String command, PodOperationContext context, OperationSupport operationSupport) throws UnsupportedEncodingException, MalformedURLException {
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append("exec?");
        commandBuilder.append("command=sh&command=-c");
        commandBuilder.append("&command=");
        commandBuilder.append(URLUtils.encodeToUTF(command));
        if (context.getContainerId() != null && !context.getContainerId().isEmpty()) {
            commandBuilder.append("&container=").append(context.getContainerId());
        }
        commandBuilder.append("&stdin=true");
        commandBuilder.append("&stderr=true");
        return new URL(URLUtils.join(operationSupport.getResourceUrl().toString(), commandBuilder.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$uploadDirectory$0(GZIPOutputStream gzip, Path pathToUpload, AtomicReference readFileException, CountDownLatch done) {
        try (TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)gzip);){
            for (File file : pathToUpload.toFile().listFiles()) {
                PodUpload.addFileToTar(null, file, tar);
            }
            tar.flush();
        }
        catch (IOException ex) {
            readFileException.set(ex);
        }
        finally {
            done.countDown();
        }
    }
}

