/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.v5_0.Status;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_0.dsl.ExecListener;
import io.fabric8.kubernetes.clnt.v5_0.dsl.ExecWatch;
import io.fabric8.kubernetes.clnt.v5_0.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v5_0.utils.InputStreamPumper;
import io.fabric8.kubernetes.clnt.v5_0.utils.NonBlockingInputStreamPumper;
import io.fabric8.kubernetes.clnt.v5_0.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecWebSocketListener
extends WebSocketListener
implements ExecWatch,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecWebSocketListener.class);
    private static final String HEIGHT = "Height";
    private static final String WIDTH = "Width";
    private final Config config;
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final OutputStream errChannel;
    private final PipedOutputStream input;
    private final PipedInputStream output;
    private final PipedInputStream error;
    private final PipedInputStream errorChannel;
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final InputStreamPumper pumper;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private final ExecListener listener;
    private final AtomicBoolean explicitlyClosed = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean cleaned = new AtomicBoolean(false);
    private final Set<Closeable> toClose = new LinkedHashSet<Closeable>();
    private ObjectMapper objectMapper;

    @Deprecated
    public ExecWebSocketListener(InputStream in, OutputStream out, OutputStream err, PipedOutputStream inputPipe, PipedInputStream outputPipe, PipedInputStream errorPipe, ExecListener listener) {
        this(new Config(), in, out, err, inputPipe, outputPipe, errorPipe, listener);
    }

    @Deprecated
    public ExecWebSocketListener(Config config, InputStream in, OutputStream out, OutputStream err, PipedOutputStream inputPipe, PipedInputStream outputPipe, PipedInputStream errorPipe, ExecListener listener) {
        this(config, in, out, err, null, inputPipe, outputPipe, errorPipe, null, listener, null);
    }

    @Deprecated
    public ExecWebSocketListener(Config config, InputStream in, OutputStream out, OutputStream err, OutputStream errChannel, PipedOutputStream inputPipe, PipedInputStream outputPipe, PipedInputStream errorPipe, PipedInputStream errorChannelPipe, ExecListener listener) {
        this(config, in, out, err, errChannel, inputPipe, outputPipe, errorPipe, errorChannelPipe, listener, null);
    }

    public ExecWebSocketListener(Config config, InputStream in, OutputStream out, OutputStream err, OutputStream errChannel, PipedOutputStream inputPipe, PipedInputStream outputPipe, PipedInputStream errorPipe, PipedInputStream errorChannelPipe, ExecListener listener, Integer bufferSize) {
        this.config = config;
        this.listener = listener;
        this.in = ExecWebSocketListener.inputStreamOrPipe(in, inputPipe, this.toClose, bufferSize);
        this.out = ExecWebSocketListener.outputStreamOrPipe(out, outputPipe, this.toClose);
        this.err = ExecWebSocketListener.outputStreamOrPipe(err, errorPipe, this.toClose);
        this.errChannel = ExecWebSocketListener.outputStreamOrPipe(errChannel, errorChannelPipe, this.toClose);
        this.input = inputPipe;
        this.output = outputPipe;
        this.error = errorPipe;
        this.errorChannel = errorChannelPipe;
        this.pumper = new NonBlockingInputStreamPumper(this.in, data -> {
            try {
                this.send((byte[])data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void close() {
        this.close(1000, "Closing...");
    }

    public void close(int code, String reason) {
        this.close(this.webSocketRef.get(), code, reason);
    }

    private void close(WebSocket ws, int code, String reason) {
        this.explicitlyClosed.set(true);
        this.closeWebSocketOnce(code, reason);
        this.onClosed(ws, code, reason);
    }

    private void cleanUpOnce() {
        if (!this.cleaned.compareAndSet(false, true)) {
            return;
        }
        try {
            Utils.closeQuietly(this.pumper);
            Utils.shutdownExecutorService(this.executorService);
        }
        finally {
            Utils.closeQuietly(this.toClose);
        }
    }

    private void closeWebSocketOnce(int code, String reason) {
        if (this.closed.get()) {
            return;
        }
        try {
            WebSocket ws = this.webSocketRef.get();
            if (ws != null) {
                ws.close(code, reason);
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Error closing WebSocket.", t);
        }
    }

    public void waitUntilReady() {
        Utils.waitUntilReady(this.queue, this.config.getWebsocketTimeout(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket webSocket, Response response) {
        try {
            if (this.in instanceof PipedInputStream && this.input != null) {
                this.input.connect((PipedInputStream)this.in);
            }
            if (this.out instanceof PipedOutputStream && this.output != null) {
                this.output.connect((PipedOutputStream)this.out);
            }
            if (this.err instanceof PipedOutputStream && this.error != null) {
                this.error.connect((PipedOutputStream)this.err);
            }
            if (this.errChannel instanceof PipedOutputStream && this.errorChannel != null) {
                this.errorChannel.connect((PipedOutputStream)this.errChannel);
            }
            this.webSocketRef.set(webSocket);
            if (!this.executorService.isShutdown()) {
                this.executorService.submit(this.pumper);
                this.started.set(true);
                this.queue.add(true);
            }
        }
        catch (IOException e) {
            this.queue.add(new KubernetesClientException(OperationSupport.createStatus(response)));
        }
        finally {
            if (this.listener != null) {
                this.listener.onOpen(response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        if (this.explicitlyClosed.get() || this.closed.get() || !this.failed.compareAndSet(false, true)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Received [" + t.getClass().getCanonicalName() + "], with message:[" + t.getMessage() + "] after ExecWebSocketListener is closed, Ignoring.");
            }
            return;
        }
        try {
            Status status = OperationSupport.createStatus(response);
            LOGGER.error("Exec Failure: HTTP:" + status.getCode() + ". Message:" + status.getMessage(), t);
            if (!this.started.get()) {
                this.queue.add(new KubernetesClientException(status));
            }
            this.cleanUpOnce();
        }
        finally {
            if (this.listener != null) {
                this.listener.onFailure(t, response);
            }
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        block10: {
            try {
                byte streamID = bytes.getByte(0);
                ByteString byteString = bytes.substring(1);
                if (byteString.size() <= 0) break block10;
                switch (streamID) {
                    case 1: {
                        if (this.out != null) {
                            this.out.write(byteString.toByteArray());
                        }
                        break;
                    }
                    case 2: {
                        if (this.err != null) {
                            this.err.write(byteString.toByteArray());
                        }
                        break;
                    }
                    case 3: {
                        if (this.errChannel != null) {
                            this.errChannel.write(byteString.toByteArray());
                        }
                        break;
                    }
                    default: {
                        throw new IOException("Unknown stream ID " + streamID);
                    }
                }
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.close(webSocket, code, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(WebSocket webSocket, int code, String reason) {
        if (!this.closed.compareAndSet(false, true) || this.failed.get()) {
            return;
        }
        LOGGER.debug("Exec Web Socket: On Close with code:[{}], due to: [{}]", (Object)code, (Object)reason);
        try {
            if (this.explicitlyClosed.get()) {
                this.cleanUpOnce();
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.onClose(code, reason);
            }
        }
    }

    @Override
    public OutputStream getInput() {
        return this.input;
    }

    @Override
    public InputStream getOutput() {
        return this.output;
    }

    @Override
    public InputStream getError() {
        return this.error;
    }

    @Override
    public InputStream getErrorChannel() {
        return this.errorChannel;
    }

    @Override
    public void resize(int cols, int rows) {
        if (cols < 0 || rows < 0) {
            return;
        }
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>(4);
            map.put(HEIGHT, rows);
            map.put(WIDTH, cols);
            byte[] bytes = this.objectMapper.writeValueAsBytes(map);
            this.send(bytes, (byte)4);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private void send(byte[] bytes, byte flag) throws IOException {
        WebSocket ws;
        if (bytes.length > 0 && (ws = this.webSocketRef.get()) != null) {
            byte[] toSend = new byte[bytes.length + 1];
            toSend[0] = flag;
            System.arraycopy(bytes, 0, toSend, 1, bytes.length);
            ws.send(ByteString.of((byte[])toSend));
        }
    }

    private void send(byte[] bytes) throws IOException {
        this.send(bytes, (byte)0);
    }

    private static InputStream inputStreamOrPipe(InputStream stream, PipedOutputStream out, Set<Closeable> toClose, Integer bufferSize) {
        if (stream != null) {
            return stream;
        }
        if (out != null) {
            PipedInputStream pis = bufferSize == null ? new PipedInputStream() : new PipedInputStream(bufferSize);
            toClose.add(out);
            toClose.add(pis);
            return pis;
        }
        return null;
    }

    private static OutputStream outputStreamOrPipe(OutputStream stream, PipedInputStream in, Set<Closeable> toClose) {
        if (stream != null) {
            return stream;
        }
        if (in != null) {
            PipedOutputStream pos = new PipedOutputStream();
            toClose.add(in);
            toClose.add(pos);
            return pos;
        }
        return null;
    }
}

