/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatus;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent;
import io.fabric8.kubernetes.api.model.storage.VolumeError;
import io.fabric8.kubernetes.api.model.storage.VolumeErrorBuilder;
import io.fabric8.kubernetes.api.model.storage.VolumeErrorFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class VolumeAttachmentStatusFluentImpl<A extends VolumeAttachmentStatusFluent<A>>
extends BaseFluent<A>
implements VolumeAttachmentStatusFluent<A> {
    private VolumeErrorBuilder attachError;
    private Boolean attached;
    private Map<String, String> attachmentMetadata;
    private VolumeErrorBuilder detachError;

    public VolumeAttachmentStatusFluentImpl() {
    }

    public VolumeAttachmentStatusFluentImpl(VolumeAttachmentStatus instance) {
        this.withAttachError(instance.getAttachError());
        this.withAttached(instance.getAttached());
        this.withAttachmentMetadata(instance.getAttachmentMetadata());
        this.withDetachError(instance.getDetachError());
    }

    @Override
    @Deprecated
    public VolumeError getAttachError() {
        return this.attachError != null ? this.attachError.build() : null;
    }

    @Override
    public VolumeError buildAttachError() {
        return this.attachError != null ? this.attachError.build() : null;
    }

    @Override
    public A withAttachError(VolumeError attachError) {
        this._visitables.get("attachError").remove(this.attachError);
        if (attachError != null) {
            this.attachError = new VolumeErrorBuilder(attachError);
            this._visitables.get("attachError").add(this.attachError);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAttachError() {
        return this.attachError != null;
    }

    @Override
    public A withNewAttachError(String message, String time) {
        return this.withAttachError(new VolumeError(message, time));
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachError() {
        return new AttachErrorNestedImpl();
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachErrorLike(VolumeError item) {
        return new AttachErrorNestedImpl(item);
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> editAttachError() {
        return this.withNewAttachErrorLike(this.getAttachError());
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachError() {
        return this.withNewAttachErrorLike(this.getAttachError() != null ? this.getAttachError() : new VolumeErrorBuilder().build());
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachErrorLike(VolumeError item) {
        return this.withNewAttachErrorLike(this.getAttachError() != null ? this.getAttachError() : item);
    }

    @Override
    public Boolean isAttached() {
        return this.attached;
    }

    @Override
    public A withAttached(Boolean attached) {
        this.attached = attached;
        return (A)this;
    }

    @Override
    public Boolean hasAttached() {
        return this.attached != null;
    }

    @Override
    public A withNewAttached(String arg1) {
        return this.withAttached(new Boolean(arg1));
    }

    @Override
    public A withNewAttached(boolean arg1) {
        return this.withAttached(new Boolean(arg1));
    }

    @Override
    public A addToAttachmentMetadata(String key, String value) {
        if (this.attachmentMetadata == null && key != null && value != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.attachmentMetadata.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null && map != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.attachmentMetadata.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttachmentMetadata(String key) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (key != null && this.attachmentMetadata != null) {
            this.attachmentMetadata.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attachmentMetadata == null) continue;
                this.attachmentMetadata.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    @Override
    public A withAttachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata == null ? null : new LinkedHashMap<String, String>(attachmentMetadata);
        return (A)this;
    }

    @Override
    public Boolean hasAttachmentMetadata() {
        return this.attachmentMetadata != null;
    }

    @Override
    @Deprecated
    public VolumeError getDetachError() {
        return this.detachError != null ? this.detachError.build() : null;
    }

    @Override
    public VolumeError buildDetachError() {
        return this.detachError != null ? this.detachError.build() : null;
    }

    @Override
    public A withDetachError(VolumeError detachError) {
        this._visitables.get("detachError").remove(this.detachError);
        if (detachError != null) {
            this.detachError = new VolumeErrorBuilder(detachError);
            this._visitables.get("detachError").add(this.detachError);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDetachError() {
        return this.detachError != null;
    }

    @Override
    public A withNewDetachError(String message, String time) {
        return this.withDetachError(new VolumeError(message, time));
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachError() {
        return new DetachErrorNestedImpl();
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachErrorLike(VolumeError item) {
        return new DetachErrorNestedImpl(item);
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> editDetachError() {
        return this.withNewDetachErrorLike(this.getDetachError());
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachError() {
        return this.withNewDetachErrorLike(this.getDetachError() != null ? this.getDetachError() : new VolumeErrorBuilder().build());
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachErrorLike(VolumeError item) {
        return this.withNewDetachErrorLike(this.getDetachError() != null ? this.getDetachError() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeAttachmentStatusFluentImpl that = (VolumeAttachmentStatusFluentImpl)o;
        if (this.attachError != null ? !this.attachError.equals(that.attachError) : that.attachError != null) {
            return false;
        }
        if (this.attached != null ? !this.attached.equals(that.attached) : that.attached != null) {
            return false;
        }
        if (this.attachmentMetadata != null ? !this.attachmentMetadata.equals(that.attachmentMetadata) : that.attachmentMetadata != null) {
            return false;
        }
        return !(this.detachError != null ? !this.detachError.equals(that.detachError) : that.detachError != null);
    }

    public int hashCode() {
        return Objects.hash(this.attachError, this.attached, this.attachmentMetadata, this.detachError, super.hashCode());
    }

    public class DetachErrorNestedImpl<N>
    extends VolumeErrorFluentImpl<VolumeAttachmentStatusFluent.DetachErrorNested<N>>
    implements VolumeAttachmentStatusFluent.DetachErrorNested<N>,
    Nested<N> {
        private final VolumeErrorBuilder builder;

        DetachErrorNestedImpl(VolumeError item) {
            this.builder = new VolumeErrorBuilder(this, item);
        }

        DetachErrorNestedImpl() {
            this.builder = new VolumeErrorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeAttachmentStatusFluentImpl.this.withDetachError(this.builder.build());
        }

        @Override
        public N endDetachError() {
            return this.and();
        }
    }

    public class AttachErrorNestedImpl<N>
    extends VolumeErrorFluentImpl<VolumeAttachmentStatusFluent.AttachErrorNested<N>>
    implements VolumeAttachmentStatusFluent.AttachErrorNested<N>,
    Nested<N> {
        private final VolumeErrorBuilder builder;

        AttachErrorNestedImpl(VolumeError item) {
            this.builder = new VolumeErrorBuilder(this, item);
        }

        AttachErrorNestedImpl() {
            this.builder = new VolumeErrorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeAttachmentStatusFluentImpl.this.withAttachError(this.builder.build());
        }

        @Override
        public N endAttachError() {
            return this.and();
        }
    }
}

