/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_0.handlers;

import io.fabric8.kubernetes.api.model.v5_0.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_0.ListOptions;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_0.Watch;
import io.fabric8.kubernetes.clnt.v5_0.Watcher;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Resource;
import io.fabric8.openshift.api.model.v5_0.ImageStream;
import io.fabric8.openshift.api.model.v5_0.ImageStreamBuilder;
import io.fabric8.openshift.clnt.v5_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_0.dsl.internal.ImageStreamOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageStreamHandler
implements ResourceHandler<ImageStream, ImageStreamBuilder> {
    @Override
    public String getKind() {
        return ImageStream.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    @Override
    public ImageStream create(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new ImageStream[0]);
    }

    @Override
    public ImageStream replace(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return ((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ImageStream reload(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)((Gettable)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageStreamBuilder edit(ImageStream item) {
        return new ImageStreamBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ImageStream item) {
        return new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, Watcher<ImageStream> watcher) {
        return ((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, String resourceVersion, Watcher<ImageStream> watcher) {
        return ((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, ListOptions options, Watcher<ImageStream> watcher) {
        return ((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ImageStream waitUntilReady(OkHttpClient client, Config config, String namespace, ImageStream item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ImageStream waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageStream item, Predicate<ImageStream> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

