/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.openshift.api.model.v5_0.operator.v1.NodeStatus;
import io.fabric8.openshift.api.model.v5_0.operator.v1.NodeStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>>
extends BaseFluent<A>
implements NodeStatusFluent<A> {
    private Integer currentRevision;
    private Integer lastFailedRevision;
    private List<String> lastFailedRevisionErrors = new ArrayList<String>();
    private String nodeName;
    private Integer targetRevision;

    public NodeStatusFluentImpl() {
    }

    public NodeStatusFluentImpl(NodeStatus instance) {
        this.withCurrentRevision(instance.getCurrentRevision());
        this.withLastFailedRevision(instance.getLastFailedRevision());
        this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors());
        this.withNodeName(instance.getNodeName());
        this.withTargetRevision(instance.getTargetRevision());
    }

    @Override
    public Integer getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public A withCurrentRevision(Integer currentRevision) {
        this.currentRevision = currentRevision;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentRevision() {
        return this.currentRevision != null;
    }

    @Override
    public Integer getLastFailedRevision() {
        return this.lastFailedRevision;
    }

    @Override
    public A withLastFailedRevision(Integer lastFailedRevision) {
        this.lastFailedRevision = lastFailedRevision;
        return (A)this;
    }

    @Override
    public Boolean hasLastFailedRevision() {
        return this.lastFailedRevision != null;
    }

    @Override
    public A addToLastFailedRevisionErrors(int index, String item) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        this.lastFailedRevisionErrors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLastFailedRevisionErrors(int index, String item) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        this.lastFailedRevisionErrors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLastFailedRevisionErrors(String ... items) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLastFailedRevisionErrors(Collection<String> items) {
        if (this.lastFailedRevisionErrors == null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedRevisionErrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLastFailedRevisionErrors(String ... items) {
        for (String item : items) {
            if (this.lastFailedRevisionErrors == null) continue;
            this.lastFailedRevisionErrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLastFailedRevisionErrors(Collection<String> items) {
        for (String item : items) {
            if (this.lastFailedRevisionErrors == null) continue;
            this.lastFailedRevisionErrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors;
    }

    @Override
    public String getLastFailedRevisionError(int index) {
        return this.lastFailedRevisionErrors.get(index);
    }

    @Override
    public String getFirstLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(0);
    }

    @Override
    public String getLastLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(this.lastFailedRevisionErrors.size() - 1);
    }

    @Override
    public String getMatchingLastFailedRevisionError(Predicate<String> predicate) {
        for (String item : this.lastFailedRevisionErrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLastFailedRevisionError(Predicate<String> predicate) {
        for (String item : this.lastFailedRevisionErrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLastFailedRevisionErrors(List<String> lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) {
            this._visitables.get("lastFailedRevisionErrors").removeAll(this.lastFailedRevisionErrors);
        }
        if (lastFailedRevisionErrors != null) {
            this.lastFailedRevisionErrors = new ArrayList<String>();
            for (String item : lastFailedRevisionErrors) {
                this.addToLastFailedRevisionErrors(item);
            }
        } else {
            this.lastFailedRevisionErrors = null;
        }
        return (A)this;
    }

    @Override
    public A withLastFailedRevisionErrors(String ... lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) {
            this.lastFailedRevisionErrors.clear();
        }
        if (lastFailedRevisionErrors != null) {
            for (String item : lastFailedRevisionErrors) {
                this.addToLastFailedRevisionErrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors != null && !this.lastFailedRevisionErrors.isEmpty();
    }

    @Override
    public A addNewLastFailedRevisionError(String arg1) {
        return this.addToLastFailedRevisionErrors(new String(arg1));
    }

    @Override
    public A addNewLastFailedRevisionError(StringBuilder arg1) {
        return this.addToLastFailedRevisionErrors(new String(arg1));
    }

    @Override
    public A addNewLastFailedRevisionError(StringBuffer arg1) {
        return this.addToLastFailedRevisionErrors(new String(arg1));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    public A withNewNodeName(String arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuilder arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuffer arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public Integer getTargetRevision() {
        return this.targetRevision;
    }

    @Override
    public A withTargetRevision(Integer targetRevision) {
        this.targetRevision = targetRevision;
        return (A)this;
    }

    @Override
    public Boolean hasTargetRevision() {
        return this.targetRevision != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatusFluentImpl that = (NodeStatusFluentImpl)o;
        if (this.currentRevision != null ? !this.currentRevision.equals(that.currentRevision) : that.currentRevision != null) {
            return false;
        }
        if (this.lastFailedRevision != null ? !this.lastFailedRevision.equals(that.lastFailedRevision) : that.lastFailedRevision != null) {
            return false;
        }
        if (this.lastFailedRevisionErrors != null ? !this.lastFailedRevisionErrors.equals(that.lastFailedRevisionErrors) : that.lastFailedRevisionErrors != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        return !(this.targetRevision != null ? !this.targetRevision.equals(that.targetRevision) : that.targetRevision != null);
    }

    public int hashCode() {
        return Objects.hash(this.currentRevision, this.lastFailedRevision, this.lastFailedRevisionErrors, this.nodeName, this.targetRevision, super.hashCode());
    }
}

