/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.openshift.api.model.v5_0.operator.v1.DNSRecordSpec;
import io.fabric8.openshift.api.model.v5_0.operator.v1.DNSRecordSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSRecordSpecFluentImpl<A extends DNSRecordSpecFluent<A>>
extends BaseFluent<A>
implements DNSRecordSpecFluent<A> {
    private String dnsName;
    private Long recordTTL;
    private String recordType;
    private List<String> targets = new ArrayList<String>();

    public DNSRecordSpecFluentImpl() {
    }

    public DNSRecordSpecFluentImpl(DNSRecordSpec instance) {
        this.withDnsName(instance.getDnsName());
        this.withRecordTTL(instance.getRecordTTL());
        this.withRecordType(instance.getRecordType());
        this.withTargets(instance.getTargets());
    }

    @Override
    public String getDnsName() {
        return this.dnsName;
    }

    @Override
    public A withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return (A)this;
    }

    @Override
    public Boolean hasDnsName() {
        return this.dnsName != null;
    }

    @Override
    public A withNewDnsName(String arg1) {
        return this.withDnsName(new String(arg1));
    }

    @Override
    public A withNewDnsName(StringBuilder arg1) {
        return this.withDnsName(new String(arg1));
    }

    @Override
    public A withNewDnsName(StringBuffer arg1) {
        return this.withDnsName(new String(arg1));
    }

    @Override
    public Long getRecordTTL() {
        return this.recordTTL;
    }

    @Override
    public A withRecordTTL(Long recordTTL) {
        this.recordTTL = recordTTL;
        return (A)this;
    }

    @Override
    public Boolean hasRecordTTL() {
        return this.recordTTL != null;
    }

    @Override
    public String getRecordType() {
        return this.recordType;
    }

    @Override
    public A withRecordType(String recordType) {
        this.recordType = recordType;
        return (A)this;
    }

    @Override
    public Boolean hasRecordType() {
        return this.recordType != null;
    }

    @Override
    public A withNewRecordType(String arg1) {
        return this.withRecordType(new String(arg1));
    }

    @Override
    public A withNewRecordType(StringBuilder arg1) {
        return this.withRecordType(new String(arg1));
    }

    @Override
    public A withNewRecordType(StringBuffer arg1) {
        return this.withRecordType(new String(arg1));
    }

    @Override
    public A addToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTargets(String ... items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTargets(Collection<String> items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTargets(String ... items) {
        for (String item : items) {
            if (this.targets == null) continue;
            this.targets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTargets(Collection<String> items) {
        for (String item : items) {
            if (this.targets == null) continue;
            this.targets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public String getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public String getFirstTarget() {
        return this.targets.get(0);
    }

    @Override
    public String getLastTarget() {
        return this.targets.get(this.targets.size() - 1);
    }

    @Override
    public String getMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTargets(List<String> targets) {
        if (this.targets != null) {
            this._visitables.get("targets").removeAll(this.targets);
        }
        if (targets != null) {
            this.targets = new ArrayList<String>();
            for (String item : targets) {
                this.addToTargets(item);
            }
        } else {
            this.targets = null;
        }
        return (A)this;
    }

    @Override
    public A withTargets(String ... targets) {
        if (this.targets != null) {
            this.targets.clear();
        }
        if (targets != null) {
            for (String item : targets) {
                this.addToTargets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    @Override
    public A addNewTarget(String arg1) {
        return this.addToTargets(new String(arg1));
    }

    @Override
    public A addNewTarget(StringBuilder arg1) {
        return this.addToTargets(new String(arg1));
    }

    @Override
    public A addNewTarget(StringBuffer arg1) {
        return this.addToTargets(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSRecordSpecFluentImpl that = (DNSRecordSpecFluentImpl)o;
        if (this.dnsName != null ? !this.dnsName.equals(that.dnsName) : that.dnsName != null) {
            return false;
        }
        if (this.recordTTL != null ? !this.recordTTL.equals(that.recordTTL) : that.recordTTL != null) {
            return false;
        }
        if (this.recordType != null ? !this.recordType.equals(that.recordType) : that.recordType != null) {
            return false;
        }
        return !(this.targets != null ? !this.targets.equals(that.targets) : that.targets != null);
    }

    public int hashCode() {
        return Objects.hash(this.dnsName, this.recordTTL, this.recordType, this.targets, super.hashCode());
    }
}

