/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_0.storage;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_0.Nested;
import io.fabric8.kubernetes.api.model.v5_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_0.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.TopologySelectorTerm;
import io.fabric8.kubernetes.api.model.v5_0.storage.StorageClass;
import io.fabric8.kubernetes.api.model.v5_0.storage.StorageClassFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StorageClassFluentImpl<A extends StorageClassFluent<A>>
extends BaseFluent<A>
implements StorageClassFluent<A> {
    private Boolean allowVolumeExpansion;
    private List<TopologySelectorTerm> allowedTopologies = new ArrayList<TopologySelectorTerm>();
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> mountOptions = new ArrayList<String>();
    private Map<String, String> parameters;
    private String provisioner;
    private String reclaimPolicy;
    private String volumeBindingMode;

    public StorageClassFluentImpl() {
    }

    public StorageClassFluentImpl(StorageClass instance) {
        this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
        this.withAllowedTopologies(instance.getAllowedTopologies());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withMountOptions(instance.getMountOptions());
        this.withParameters(instance.getParameters());
        this.withProvisioner(instance.getProvisioner());
        this.withReclaimPolicy(instance.getReclaimPolicy());
        this.withVolumeBindingMode(instance.getVolumeBindingMode());
    }

    @Override
    public Boolean isAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    @Override
    public A withAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return (A)this;
    }

    @Override
    public Boolean hasAllowVolumeExpansion() {
        return this.allowVolumeExpansion != null;
    }

    @Override
    public A withNewAllowVolumeExpansion(String arg1) {
        return this.withAllowVolumeExpansion(new Boolean(arg1));
    }

    @Override
    public A withNewAllowVolumeExpansion(boolean arg1) {
        return this.withAllowVolumeExpansion(new Boolean(arg1));
    }

    @Override
    public A addToAllowedTopologies(int index, TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        this.allowedTopologies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedTopologies(int index, TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        this.allowedTopologies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedTopologies(TopologySelectorTerm ... items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        for (TopologySelectorTerm item : items) {
            this.allowedTopologies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedTopologies(Collection<TopologySelectorTerm> items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        for (TopologySelectorTerm item : items) {
            this.allowedTopologies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedTopologies(TopologySelectorTerm ... items) {
        for (TopologySelectorTerm item : items) {
            if (this.allowedTopologies == null) continue;
            this.allowedTopologies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedTopologies(Collection<TopologySelectorTerm> items) {
        for (TopologySelectorTerm item : items) {
            if (this.allowedTopologies == null) continue;
            this.allowedTopologies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<TopologySelectorTerm> getAllowedTopologies() {
        return this.allowedTopologies;
    }

    @Override
    public TopologySelectorTerm getAllowedTopology(int index) {
        return this.allowedTopologies.get(index);
    }

    @Override
    public TopologySelectorTerm getFirstAllowedTopology() {
        return this.allowedTopologies.get(0);
    }

    @Override
    public TopologySelectorTerm getLastAllowedTopology() {
        return this.allowedTopologies.get(this.allowedTopologies.size() - 1);
    }

    @Override
    public TopologySelectorTerm getMatchingAllowedTopology(Predicate<TopologySelectorTerm> predicate) {
        for (TopologySelectorTerm item : this.allowedTopologies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedTopology(Predicate<TopologySelectorTerm> predicate) {
        for (TopologySelectorTerm item : this.allowedTopologies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedTopologies(List<TopologySelectorTerm> allowedTopologies) {
        if (this.allowedTopologies != null) {
            this._visitables.get("allowedTopologies").removeAll(this.allowedTopologies);
        }
        if (allowedTopologies != null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
            for (TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        } else {
            this.allowedTopologies = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedTopologies(TopologySelectorTerm ... allowedTopologies) {
        if (this.allowedTopologies != null) {
            this.allowedTopologies.clear();
        }
        if (allowedTopologies != null) {
            for (TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedTopologies() {
        return this.allowedTopologies != null && !this.allowedTopologies.isEmpty();
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public StorageClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public StorageClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public StorageClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public StorageClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public StorageClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMountOptions(String ... items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMountOptions(Collection<String> items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMountOptions(String ... items) {
        for (String item : items) {
            if (this.mountOptions == null) continue;
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMountOptions(Collection<String> items) {
        for (String item : items) {
            if (this.mountOptions == null) continue;
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    @Override
    public String getMountOption(int index) {
        return this.mountOptions.get(index);
    }

    @Override
    public String getFirstMountOption() {
        return this.mountOptions.get(0);
    }

    @Override
    public String getLastMountOption() {
        return this.mountOptions.get(this.mountOptions.size() - 1);
    }

    @Override
    public String getMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMountOptions(List<String> mountOptions) {
        if (this.mountOptions != null) {
            this._visitables.get("mountOptions").removeAll(this.mountOptions);
        }
        if (mountOptions != null) {
            this.mountOptions = new ArrayList<String>();
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        } else {
            this.mountOptions = null;
        }
        return (A)this;
    }

    @Override
    public A withMountOptions(String ... mountOptions) {
        if (this.mountOptions != null) {
            this.mountOptions.clear();
        }
        if (mountOptions != null) {
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMountOptions() {
        return this.mountOptions != null && !this.mountOptions.isEmpty();
    }

    @Override
    public A addNewMountOption(String arg1) {
        return this.addToMountOptions(new String(arg1));
    }

    @Override
    public A addNewMountOption(StringBuilder arg1) {
        return this.addToMountOptions(new String(arg1));
    }

    @Override
    public A addNewMountOption(StringBuffer arg1) {
        return this.addToMountOptions(new String(arg1));
    }

    @Override
    public A addToParameters(String key, String value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToParameters(Map<String, String> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(Map<String, String> map) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public A withParameters(Map<String, String> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, String>(parameters);
        return (A)this;
    }

    @Override
    public Boolean hasParameters() {
        return this.parameters != null;
    }

    @Override
    public String getProvisioner() {
        return this.provisioner;
    }

    @Override
    public A withProvisioner(String provisioner) {
        this.provisioner = provisioner;
        return (A)this;
    }

    @Override
    public Boolean hasProvisioner() {
        return this.provisioner != null;
    }

    @Override
    public A withNewProvisioner(String arg1) {
        return this.withProvisioner(new String(arg1));
    }

    @Override
    public A withNewProvisioner(StringBuilder arg1) {
        return this.withProvisioner(new String(arg1));
    }

    @Override
    public A withNewProvisioner(StringBuffer arg1) {
        return this.withProvisioner(new String(arg1));
    }

    @Override
    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    @Override
    public A withReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasReclaimPolicy() {
        return this.reclaimPolicy != null;
    }

    @Override
    public A withNewReclaimPolicy(String arg1) {
        return this.withReclaimPolicy(new String(arg1));
    }

    @Override
    public A withNewReclaimPolicy(StringBuilder arg1) {
        return this.withReclaimPolicy(new String(arg1));
    }

    @Override
    public A withNewReclaimPolicy(StringBuffer arg1) {
        return this.withReclaimPolicy(new String(arg1));
    }

    @Override
    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    @Override
    public A withVolumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeBindingMode() {
        return this.volumeBindingMode != null;
    }

    @Override
    public A withNewVolumeBindingMode(String arg1) {
        return this.withVolumeBindingMode(new String(arg1));
    }

    @Override
    public A withNewVolumeBindingMode(StringBuilder arg1) {
        return this.withVolumeBindingMode(new String(arg1));
    }

    @Override
    public A withNewVolumeBindingMode(StringBuffer arg1) {
        return this.withVolumeBindingMode(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageClassFluentImpl that = (StorageClassFluentImpl)o;
        if (this.allowVolumeExpansion != null ? !this.allowVolumeExpansion.equals(that.allowVolumeExpansion) : that.allowVolumeExpansion != null) {
            return false;
        }
        if (this.allowedTopologies != null ? !this.allowedTopologies.equals(that.allowedTopologies) : that.allowedTopologies != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.mountOptions != null ? !this.mountOptions.equals(that.mountOptions) : that.mountOptions != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.provisioner != null ? !this.provisioner.equals(that.provisioner) : that.provisioner != null) {
            return false;
        }
        if (this.reclaimPolicy != null ? !this.reclaimPolicy.equals(that.reclaimPolicy) : that.reclaimPolicy != null) {
            return false;
        }
        return !(this.volumeBindingMode != null ? !this.volumeBindingMode.equals(that.volumeBindingMode) : that.volumeBindingMode != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowVolumeExpansion, this.allowedTopologies, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.provisioner, this.reclaimPolicy, this.volumeBindingMode, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<StorageClassFluent.MetadataNested<N>>
    implements StorageClassFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)StorageClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

