/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_0;

import io.fabric8.kubernetes.api.builder.v5_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_0.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.v5_0.NodeDaemonEndpointsFluent;
import io.fabric8.kubernetes.api.model.v5_0.NodeDaemonEndpointsFluentImpl;
import java.util.Objects;

public class NodeDaemonEndpointsBuilder
extends NodeDaemonEndpointsFluentImpl<NodeDaemonEndpointsBuilder>
implements VisitableBuilder<NodeDaemonEndpoints, NodeDaemonEndpointsBuilder> {
    NodeDaemonEndpointsFluent<?> fluent;
    Boolean validationEnabled;

    public NodeDaemonEndpointsBuilder() {
        this(true);
    }

    public NodeDaemonEndpointsBuilder(Boolean validationEnabled) {
        this(new NodeDaemonEndpoints(), validationEnabled);
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeDaemonEndpoints(), validationEnabled);
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent, NodeDaemonEndpoints instance) {
        this(fluent, instance, true);
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent, NodeDaemonEndpoints instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKubeletEndpoint(instance.getKubeletEndpoint());
        this.validationEnabled = validationEnabled;
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpoints instance) {
        this(instance, (Boolean)true);
    }

    public NodeDaemonEndpointsBuilder(NodeDaemonEndpoints instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKubeletEndpoint(instance.getKubeletEndpoint());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeDaemonEndpoints build() {
        NodeDaemonEndpoints buildable = new NodeDaemonEndpoints(this.fluent.getKubeletEndpoint());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeDaemonEndpointsBuilder that = (NodeDaemonEndpointsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

