/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_0;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_0.Nested;
import io.fabric8.kubernetes.api.model.v5_0.EndpointAddress;
import io.fabric8.kubernetes.api.model.v5_0.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.v5_0.EndpointAddressFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.EndpointPort;
import io.fabric8.kubernetes.api.model.v5_0.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.v5_0.EndpointPortFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.EndpointSubset;
import io.fabric8.kubernetes.api.model.v5_0.EndpointSubsetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointSubsetFluentImpl<A extends EndpointSubsetFluent<A>>
extends BaseFluent<A>
implements EndpointSubsetFluent<A> {
    private List<EndpointAddressBuilder> addresses = new ArrayList<EndpointAddressBuilder>();
    private List<EndpointAddressBuilder> notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
    private List<EndpointPortBuilder> ports = new ArrayList<EndpointPortBuilder>();

    public EndpointSubsetFluentImpl() {
    }

    public EndpointSubsetFluentImpl(EndpointSubset instance) {
        this.withAddresses(instance.getAddresses());
        this.withNotReadyAddresses(instance.getNotReadyAddresses());
        this.withPorts(instance.getPorts());
    }

    @Override
    public A addToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<EndpointAddressBuilder>();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        this._visitables.get("addresses").add(index >= 0 ? index : this._visitables.get("addresses").size(), builder);
        this.addresses.add(index >= 0 ? index : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<EndpointAddressBuilder>();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("addresses").size()) {
            this._visitables.get("addresses").add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(EndpointAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<EndpointAddressBuilder>();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<EndpointAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<EndpointAddressBuilder>();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<EndpointAddress> items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<EndpointAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointAddress> getAddresses() {
        return EndpointSubsetFluentImpl.build(this.addresses);
    }

    @Override
    public List<EndpointAddress> buildAddresses() {
        return EndpointSubsetFluentImpl.build(this.addresses);
    }

    @Override
    public EndpointAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public EndpointAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public EndpointAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public EndpointAddress buildMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<EndpointAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<EndpointAddressBuilder>();
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(EndpointAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(int index, EndpointAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        this._visitables.get("notReadyAddresses").add(index >= 0 ? index : this._visitables.get("notReadyAddresses").size(), builder);
        this.notReadyAddresses.add(index >= 0 ? index : this.notReadyAddresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("notReadyAddresses").size()) {
            this._visitables.get("notReadyAddresses").add(builder);
        } else {
            this._visitables.get("notReadyAddresses").set(index, builder);
        }
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this.notReadyAddresses.add(builder);
        } else {
            this.notReadyAddresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToNotReadyAddresses(EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotReadyAddresses(Collection<EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotReadyAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotReadyAddresses(Collection<EndpointAddress> items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromNotReadyAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        Iterator<EndpointAddressBuilder> each = this.notReadyAddresses.iterator();
        Object visitables = this._visitables.get("notReadyAddresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointAddress> getNotReadyAddresses() {
        return EndpointSubsetFluentImpl.build(this.notReadyAddresses);
    }

    @Override
    public List<EndpointAddress> buildNotReadyAddresses() {
        return EndpointSubsetFluentImpl.build(this.notReadyAddresses);
    }

    @Override
    public EndpointAddress buildNotReadyAddress(int index) {
        return this.notReadyAddresses.get(index).build();
    }

    @Override
    public EndpointAddress buildFirstNotReadyAddress() {
        return this.notReadyAddresses.get(0).build();
    }

    @Override
    public EndpointAddress buildLastNotReadyAddress() {
        return this.notReadyAddresses.get(this.notReadyAddresses.size() - 1).build();
    }

    @Override
    public EndpointAddress buildMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this._visitables.get("notReadyAddresses").removeAll(this.notReadyAddresses);
        }
        if (notReadyAddresses != null) {
            this.notReadyAddresses = new ArrayList<EndpointAddressBuilder>();
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        } else {
            this.notReadyAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withNotReadyAddresses(EndpointAddress ... notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this.notReadyAddresses.clear();
        }
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotReadyAddresses() {
        return this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty();
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(-1, item);
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index, EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(index, item);
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(int index) {
        if (this.notReadyAddresses.size() <= index) {
            throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress() {
        if (this.notReadyAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(0, this.buildNotReadyAddress(0));
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress() {
        int index = this.notReadyAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.notReadyAddresses.size(); ++i) {
            if (!predicate.test(this.notReadyAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public A addToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(EndpointPort ... items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<EndpointPort> items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointPort> getPorts() {
        return EndpointSubsetFluentImpl.build(this.ports);
    }

    @Override
    public List<EndpointPort> buildPorts() {
        return EndpointSubsetFluentImpl.build(this.ports);
    }

    @Override
    public EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(String appProtocol, String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(appProtocol, name, port, protocol));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> setNewPortLike(int index, EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.notReadyAddresses != null ? !this.notReadyAddresses.equals(that.notReadyAddresses) : that.notReadyAddresses != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports, super.hashCode());
    }

    public class PortsNestedImpl<N>
    extends EndpointPortFluentImpl<EndpointSubsetFluent.PortsNested<N>>
    implements EndpointSubsetFluent.PortsNested<N>,
    Nested<N> {
        private final EndpointPortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, EndpointPort item) {
            this.index = index;
            this.builder = new EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class NotReadyAddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.NotReadyAddressesNested<N>>
    implements EndpointSubsetFluent.NotReadyAddressesNested<N>,
    Nested<N> {
        private final EndpointAddressBuilder builder;
        private final int index;

        NotReadyAddressesNestedImpl(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        NotReadyAddressesNestedImpl() {
            this.index = -1;
            this.builder = new EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.setToNotReadyAddresses(this.index, this.builder.build());
        }

        @Override
        public N endNotReadyAddress() {
            return this.and();
        }
    }

    public class AddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.AddressesNested<N>>
    implements EndpointSubsetFluent.AddressesNested<N>,
    Nested<N> {
        private final EndpointAddressBuilder builder;
        private final int index;

        AddressesNestedImpl(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

