/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v5_0;

import io.fabric8.kubernetes.api.builder.v5_0.Builder;
import io.fabric8.kubernetes.api.builder.v5_0.Editable;
import io.fabric8.kubernetes.api.builder.v5_0.Fluent;
import io.fabric8.kubernetes.api.builder.v5_0.PathAwareTypedVisitor;
import io.fabric8.kubernetes.api.builder.v5_0.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v5_0.Visitable;
import io.fabric8.kubernetes.api.builder.v5_0.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v5_0.VisitableMap;
import io.fabric8.kubernetes.api.builder.v5_0.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BaseFluent<F extends Fluent<F>>
implements Fluent<F>,
Visitable<F> {
    private static final String VISIT = "visit";
    public final VisitableMap _visitables = new VisitableMap();

    public static <T> VisitableBuilder<T, ?> builderOf(T item) {
        Object editor;
        if (item instanceof Editable && (editor = ((Editable)item).edit()) instanceof VisitableBuilder) {
            return (VisitableBuilder)editor;
        }
        try {
            return (VisitableBuilder)Class.forName(item.getClass().getName() + "Builder").getConstructor(item.getClass()).newInstance(item);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create builder for: " + item.getClass(), e);
        }
    }

    public static <T> ArrayList<T> build(List<? extends Builder<? extends T>> list) {
        if (list == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Builder<T> builder : list) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> List<T> build(Set<? extends Builder<? extends T>> set) {
        if (set == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Builder<T> builder : set) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> ArrayList<T> aggregate(List<? extends T> ... lists) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (List<T> list : lists) {
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    public static <T> LinkedHashSet<T> aggregate(Set<? extends T> ... sets) {
        LinkedHashSet<? extends T> result = new LinkedHashSet<T>();
        for (Set<T> set : sets) {
            if (set == null) continue;
            result.addAll(set);
        }
        return result;
    }

    private static <V extends Visitor, F> Boolean canVisit(V visitor, F fluent) {
        Class actaulParentType;
        PathAwareTypedVisitor pathAwareTypedVisitor;
        Class parentType;
        if (visitor instanceof TypedVisitor && !((TypedVisitor)visitor).getType().isAssignableFrom(fluent.getClass())) {
            return false;
        }
        if (visitor instanceof PathAwareTypedVisitor && !(parentType = (pathAwareTypedVisitor = (PathAwareTypedVisitor)visitor).getParentType()).isAssignableFrom(actaulParentType = pathAwareTypedVisitor.getActualParentType())) {
            return false;
        }
        return BaseFluent.hasCompatibleVisitMethod(visitor, fluent);
    }

    private static <V, F> Boolean hasCompatibleVisitMethod(V visitor, F fluent) {
        for (Method method : visitor.getClass().getMethods()) {
            if (!method.getName().equals(VISIT) || method.getParameterTypes().length != 1) continue;
            Class<?> visitorType = method.getParameterTypes()[0];
            if (visitorType.isAssignableFrom(fluent.getClass())) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public F accept(Visitor ... visitors) {
        if (BaseFluent.isPathAwareVisitorArray(visitors).booleanValue()) {
            return this.acceptPathAware(BaseFluent.asPathAwareVisitorArray(visitors));
        }
        return this.acceptInternal(visitors);
    }

    @Override
    public <V> F accept(final Class<V> type, final Visitor<V> visitor) {
        return (F)this.accept(new Visitor[]{new TypedVisitor<V>(){

            @Override
            public Class<V> getType() {
                return type;
            }

            @Override
            public void visit(V element) {
                visitor.visit(element);
            }
        }});
    }

    private F acceptInternal(Visitor ... visitors) {
        for (Visitor visitor : visitors) {
            for (Visitable visitable : this._visitables) {
                visitable.accept(visitor);
            }
            if (!BaseFluent.canVisit(visitor, this).booleanValue()) continue;
            visitor.visit(this);
        }
        return (F)this;
    }

    private F acceptPathAware(PathAwareTypedVisitor ... pathAwareTypedVisitors) {
        return this.acceptInternal((Visitor[])Arrays.stream(pathAwareTypedVisitors).map(p -> p.next(this)).toArray(PathAwareTypedVisitor[]::new));
    }

    private static Boolean isPathAwareVisitorArray(Visitor ... visitors) {
        return !Arrays.stream(visitors).filter(v -> !(v instanceof PathAwareTypedVisitor)).findAny().isPresent();
    }

    private static PathAwareTypedVisitor[] asPathAwareVisitorArray(Visitor ... visitors) {
        return (PathAwareTypedVisitor[])Arrays.stream(visitors).filter(v -> v instanceof PathAwareTypedVisitor).map(v -> (PathAwareTypedVisitor)v).toArray(PathAwareTypedVisitor[]::new);
    }
}

