/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition;
import io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder;
import io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition;
import io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder;
import io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.NetworkSpec;
import io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.ProxyConfig;
import io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkSpecFluentImpl<A extends NetworkSpecFluent<A>>
extends BaseFluent<A>
implements NetworkSpecFluent<A> {
    private List<AdditionalNetworkDefinitionBuilder> additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
    private List<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
    private DefaultNetworkDefinitionBuilder defaultNetwork;
    private Boolean deployKubeProxy;
    private Boolean disableMultiNetwork;
    private ProxyConfigBuilder kubeProxyConfig;
    private String logLevel;
    private List<String> serviceNetwork = new ArrayList<String>();

    public NetworkSpecFluentImpl() {
    }

    public NetworkSpecFluentImpl(NetworkSpec instance) {
        this.withAdditionalNetworks(instance.getAdditionalNetworks());
        this.withClusterNetwork(instance.getClusterNetwork());
        this.withDefaultNetwork(instance.getDefaultNetwork());
        this.withDeployKubeProxy(instance.getDeployKubeProxy());
        this.withDisableMultiNetwork(instance.getDisableMultiNetwork());
        this.withKubeProxyConfig(instance.getKubeProxyConfig());
        this.withLogLevel(instance.getLogLevel());
        this.withServiceNetwork(instance.getServiceNetwork());
    }

    @Override
    public A addToAdditionalNetworks(int index, AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
        }
        AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
        this._visitables.get("additionalNetworks").add(index >= 0 ? index : this._visitables.get("additionalNetworks").size(), builder);
        this.additionalNetworks.add(index >= 0 ? index : this.additionalNetworks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAdditionalNetworks(int index, AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
        }
        AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
        if (index < 0 || index >= this._visitables.get("additionalNetworks").size()) {
            this._visitables.get("additionalNetworks").add(builder);
        } else {
            this._visitables.get("additionalNetworks").set(index, builder);
        }
        if (index < 0 || index >= this.additionalNetworks.size()) {
            this.additionalNetworks.add(builder);
        } else {
            this.additionalNetworks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalNetworks(AdditionalNetworkDefinition ... items) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
        }
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
        }
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalNetworks(AdditionalNetworkDefinition ... items) {
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").remove(builder);
            if (this.additionalNetworks == null) continue;
            this.additionalNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").remove(builder);
            if (this.additionalNetworks == null) continue;
            this.additionalNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        if (this.additionalNetworks == null) {
            return (A)this;
        }
        Iterator<AdditionalNetworkDefinitionBuilder> each = this.additionalNetworks.iterator();
        Object visitables = this._visitables.get("additionalNetworks");
        while (each.hasNext()) {
            AdditionalNetworkDefinitionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AdditionalNetworkDefinition> getAdditionalNetworks() {
        return NetworkSpecFluentImpl.build(this.additionalNetworks);
    }

    @Override
    public List<AdditionalNetworkDefinition> buildAdditionalNetworks() {
        return NetworkSpecFluentImpl.build(this.additionalNetworks);
    }

    @Override
    public AdditionalNetworkDefinition buildAdditionalNetwork(int index) {
        return this.additionalNetworks.get(index).build();
    }

    @Override
    public AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
        return this.additionalNetworks.get(0).build();
    }

    @Override
    public AdditionalNetworkDefinition buildLastAdditionalNetwork() {
        return this.additionalNetworks.get(this.additionalNetworks.size() - 1).build();
    }

    @Override
    public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        for (AdditionalNetworkDefinitionBuilder item : this.additionalNetworks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        for (AdditionalNetworkDefinitionBuilder item : this.additionalNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks) {
        if (this.additionalNetworks != null) {
            this._visitables.get("additionalNetworks").removeAll(this.additionalNetworks);
        }
        if (additionalNetworks != null) {
            this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
            for (AdditionalNetworkDefinition item : additionalNetworks) {
                this.addToAdditionalNetworks(item);
            }
        } else {
            this.additionalNetworks = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalNetworks(AdditionalNetworkDefinition ... additionalNetworks) {
        if (this.additionalNetworks != null) {
            this.additionalNetworks.clear();
        }
        if (additionalNetworks != null) {
            for (AdditionalNetworkDefinition item : additionalNetworks) {
                this.addToAdditionalNetworks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalNetworks() {
        return this.additionalNetworks != null && !this.additionalNetworks.isEmpty();
    }

    @Override
    public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork() {
        return new AdditionalNetworksNestedImpl();
    }

    @Override
    public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item) {
        return new AdditionalNetworksNestedImpl(-1, item);
    }

    @Override
    public NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(int index, AdditionalNetworkDefinition item) {
        return new AdditionalNetworksNestedImpl(index, item);
    }

    @Override
    public NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(int index) {
        if (this.additionalNetworks.size() <= index) {
            throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
        }
        return this.setNewAdditionalNetworkLike(index, this.buildAdditionalNetwork(index));
    }

    @Override
    public NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
        if (this.additionalNetworks.size() == 0) {
            throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
        }
        return this.setNewAdditionalNetworkLike(0, this.buildAdditionalNetwork(0));
    }

    @Override
    public NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork() {
        int index = this.additionalNetworks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
        }
        return this.setNewAdditionalNetworkLike(index, this.buildAdditionalNetwork(index));
    }

    @Override
    public NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.additionalNetworks.size(); ++i) {
            if (!predicate.test(this.additionalNetworks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
        }
        return this.setNewAdditionalNetworkLike(index, this.buildAdditionalNetwork(index));
    }

    @Override
    public A addToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        this._visitables.get("clusterNetwork").add(index >= 0 ? index : this._visitables.get("clusterNetwork").size(), builder);
        this.clusterNetwork.add(index >= 0 ? index : this.clusterNetwork.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get("clusterNetwork").size()) {
            this._visitables.get("clusterNetwork").add(builder);
        } else {
            this._visitables.get("clusterNetwork").set(index, builder);
        }
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this.clusterNetwork.add(builder);
        } else {
            this.clusterNetwork.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterNetwork(ClusterNetworkEntry ... items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            if (this.clusterNetwork == null) continue;
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            if (this.clusterNetwork == null) continue;
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetwork.iterator();
        Object visitables = this._visitables.get("clusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterNetworkEntry> getClusterNetwork() {
        return NetworkSpecFluentImpl.build(this.clusterNetwork);
    }

    @Override
    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return NetworkSpecFluentImpl.build(this.clusterNetwork);
    }

    @Override
    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    @Override
    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    @Override
    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(this.clusterNetwork.size() - 1).build();
    }

    @Override
    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) {
            this._visitables.get("clusterNetwork").removeAll(this.clusterNetwork);
        }
        if (clusterNetwork != null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        } else {
            this.clusterNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterNetwork(ClusterNetworkEntry ... clusterNetwork) {
        if (this.clusterNetwork != null) {
            this.clusterNetwork.clear();
        }
        if (clusterNetwork != null) {
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterNetwork() {
        return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
    }

    @Override
    public A addNewClusterNetwork(String cidr, Integer hostPrefix) {
        return this.addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    @Override
    public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNestedImpl();
    }

    @Override
    public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(-1, item);
    }

    @Override
    public NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(index, item);
    }

    @Override
    public NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (this.clusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (this.clusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    @Override
    public NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = this.clusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetwork.size(); ++i) {
            if (!predicate.test(this.clusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    @Deprecated
    public DefaultNetworkDefinition getDefaultNetwork() {
        return this.defaultNetwork != null ? this.defaultNetwork.build() : null;
    }

    @Override
    public DefaultNetworkDefinition buildDefaultNetwork() {
        return this.defaultNetwork != null ? this.defaultNetwork.build() : null;
    }

    @Override
    public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork) {
        this._visitables.get("defaultNetwork").remove(this.defaultNetwork);
        if (defaultNetwork != null) {
            this.defaultNetwork = new DefaultNetworkDefinitionBuilder(defaultNetwork);
            this._visitables.get("defaultNetwork").add(this.defaultNetwork);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultNetwork() {
        return this.defaultNetwork != null;
    }

    @Override
    public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork() {
        return new DefaultNetworkNestedImpl();
    }

    @Override
    public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item) {
        return new DefaultNetworkNestedImpl(item);
    }

    @Override
    public NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork() {
        return this.withNewDefaultNetworkLike(this.getDefaultNetwork());
    }

    @Override
    public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork() {
        return this.withNewDefaultNetworkLike(this.getDefaultNetwork() != null ? this.getDefaultNetwork() : new DefaultNetworkDefinitionBuilder().build());
    }

    @Override
    public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item) {
        return this.withNewDefaultNetworkLike(this.getDefaultNetwork() != null ? this.getDefaultNetwork() : item);
    }

    @Override
    public Boolean isDeployKubeProxy() {
        return this.deployKubeProxy;
    }

    @Override
    public A withDeployKubeProxy(Boolean deployKubeProxy) {
        this.deployKubeProxy = deployKubeProxy;
        return (A)this;
    }

    @Override
    public Boolean hasDeployKubeProxy() {
        return this.deployKubeProxy != null;
    }

    @Override
    public A withNewDeployKubeProxy(String arg1) {
        return this.withDeployKubeProxy(new Boolean(arg1));
    }

    @Override
    public A withNewDeployKubeProxy(boolean arg1) {
        return this.withDeployKubeProxy(new Boolean(arg1));
    }

    @Override
    public Boolean isDisableMultiNetwork() {
        return this.disableMultiNetwork;
    }

    @Override
    public A withDisableMultiNetwork(Boolean disableMultiNetwork) {
        this.disableMultiNetwork = disableMultiNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasDisableMultiNetwork() {
        return this.disableMultiNetwork != null;
    }

    @Override
    public A withNewDisableMultiNetwork(String arg1) {
        return this.withDisableMultiNetwork(new Boolean(arg1));
    }

    @Override
    public A withNewDisableMultiNetwork(boolean arg1) {
        return this.withDisableMultiNetwork(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public ProxyConfig getKubeProxyConfig() {
        return this.kubeProxyConfig != null ? this.kubeProxyConfig.build() : null;
    }

    @Override
    public ProxyConfig buildKubeProxyConfig() {
        return this.kubeProxyConfig != null ? this.kubeProxyConfig.build() : null;
    }

    @Override
    public A withKubeProxyConfig(ProxyConfig kubeProxyConfig) {
        this._visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
        if (kubeProxyConfig != null) {
            this.kubeProxyConfig = new ProxyConfigBuilder(kubeProxyConfig);
            this._visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKubeProxyConfig() {
        return this.kubeProxyConfig != null;
    }

    @Override
    public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig() {
        return new KubeProxyConfigNestedImpl();
    }

    @Override
    public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item) {
        return new KubeProxyConfigNestedImpl(item);
    }

    @Override
    public NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig() {
        return this.withNewKubeProxyConfigLike(this.getKubeProxyConfig());
    }

    @Override
    public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
        return this.withNewKubeProxyConfigLike(this.getKubeProxyConfig() != null ? this.getKubeProxyConfig() : new ProxyConfigBuilder().build());
    }

    @Override
    public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item) {
        return this.withNewKubeProxyConfigLike(this.getKubeProxyConfig() != null ? this.getKubeProxyConfig() : item);
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public A withNewLogLevel(String arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A withNewLogLevel(StringBuilder arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A withNewLogLevel(StringBuffer arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A addToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceNetwork(String ... items) {
        for (String item : items) {
            if (this.serviceNetwork == null) continue;
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceNetwork(Collection<String> items) {
        for (String item : items) {
            if (this.serviceNetwork == null) continue;
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    @Override
    public String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    @Override
    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    @Override
    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(this.serviceNetwork.size() - 1);
    }

    @Override
    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceNetwork(List<String> serviceNetwork) {
        if (this.serviceNetwork != null) {
            this._visitables.get("serviceNetwork").removeAll(this.serviceNetwork);
        }
        if (serviceNetwork != null) {
            this.serviceNetwork = new ArrayList<String>();
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        } else {
            this.serviceNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceNetwork(String ... serviceNetwork) {
        if (this.serviceNetwork != null) {
            this.serviceNetwork.clear();
        }
        if (serviceNetwork != null) {
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceNetwork() {
        return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
    }

    @Override
    public A addNewServiceNetwork(String arg1) {
        return this.addToServiceNetwork(new String(arg1));
    }

    @Override
    public A addNewServiceNetwork(StringBuilder arg1) {
        return this.addToServiceNetwork(new String(arg1));
    }

    @Override
    public A addNewServiceNetwork(StringBuffer arg1) {
        return this.addToServiceNetwork(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSpecFluentImpl that = (NetworkSpecFluentImpl)o;
        if (this.additionalNetworks != null ? !this.additionalNetworks.equals(that.additionalNetworks) : that.additionalNetworks != null) {
            return false;
        }
        if (this.clusterNetwork != null ? !this.clusterNetwork.equals(that.clusterNetwork) : that.clusterNetwork != null) {
            return false;
        }
        if (this.defaultNetwork != null ? !this.defaultNetwork.equals(that.defaultNetwork) : that.defaultNetwork != null) {
            return false;
        }
        if (this.deployKubeProxy != null ? !this.deployKubeProxy.equals(that.deployKubeProxy) : that.deployKubeProxy != null) {
            return false;
        }
        if (this.disableMultiNetwork != null ? !this.disableMultiNetwork.equals(that.disableMultiNetwork) : that.disableMultiNetwork != null) {
            return false;
        }
        if (this.kubeProxyConfig != null ? !this.kubeProxyConfig.equals(that.kubeProxyConfig) : that.kubeProxyConfig != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        return !(this.serviceNetwork != null ? !this.serviceNetwork.equals(that.serviceNetwork) : that.serviceNetwork != null);
    }

    public int hashCode() {
        return Objects.hash(this.additionalNetworks, this.clusterNetwork, this.defaultNetwork, this.deployKubeProxy, this.disableMultiNetwork, this.kubeProxyConfig, this.logLevel, this.serviceNetwork, super.hashCode());
    }

    public class KubeProxyConfigNestedImpl<N>
    extends ProxyConfigFluentImpl<NetworkSpecFluent.KubeProxyConfigNested<N>>
    implements NetworkSpecFluent.KubeProxyConfigNested<N>,
    Nested<N> {
        private final ProxyConfigBuilder builder;

        KubeProxyConfigNestedImpl(ProxyConfig item) {
            this.builder = new ProxyConfigBuilder(this, item);
        }

        KubeProxyConfigNestedImpl() {
            this.builder = new ProxyConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluentImpl.this.withKubeProxyConfig(this.builder.build());
        }

        @Override
        public N endKubeProxyConfig() {
            return this.and();
        }
    }

    public class DefaultNetworkNestedImpl<N>
    extends DefaultNetworkDefinitionFluentImpl<NetworkSpecFluent.DefaultNetworkNested<N>>
    implements NetworkSpecFluent.DefaultNetworkNested<N>,
    Nested<N> {
        private final DefaultNetworkDefinitionBuilder builder;

        DefaultNetworkNestedImpl(DefaultNetworkDefinition item) {
            this.builder = new DefaultNetworkDefinitionBuilder(this, item);
        }

        DefaultNetworkNestedImpl() {
            this.builder = new DefaultNetworkDefinitionBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluentImpl.this.withDefaultNetwork(this.builder.build());
        }

        @Override
        public N endDefaultNetwork() {
            return this.and();
        }
    }

    public class ClusterNetworkNestedImpl<N>
    extends ClusterNetworkEntryFluentImpl<NetworkSpecFluent.ClusterNetworkNested<N>>
    implements NetworkSpecFluent.ClusterNetworkNested<N>,
    Nested<N> {
        private final ClusterNetworkEntryBuilder builder;
        private final int index;

        ClusterNetworkNestedImpl(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        ClusterNetworkNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluentImpl.this.setToClusterNetwork(this.index, this.builder.build());
        }

        @Override
        public N endClusterNetwork() {
            return this.and();
        }
    }

    public class AdditionalNetworksNestedImpl<N>
    extends AdditionalNetworkDefinitionFluentImpl<NetworkSpecFluent.AdditionalNetworksNested<N>>
    implements NetworkSpecFluent.AdditionalNetworksNested<N>,
    Nested<N> {
        private final AdditionalNetworkDefinitionBuilder builder;
        private final int index;

        AdditionalNetworksNestedImpl(int index, AdditionalNetworkDefinition item) {
            this.index = index;
            this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
        }

        AdditionalNetworksNestedImpl() {
            this.index = -1;
            this.builder = new AdditionalNetworkDefinitionBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluentImpl.this.setToAdditionalNetworks(this.index, this.builder.build());
        }

        @Override
        public N endAdditionalNetwork() {
            return this.and();
        }
    }
}

