/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Pluralize;
import io.fabric8.kubernetes.client.utils.Utils;

public class CustomResourceDefinitionContext {
    private String name;
    private String group;
    private String scope;
    private String plural;
    private String version;
    private String kind;

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getScope() {
        return this.scope;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public static CustomResourceDefinitionContext fromCustomResourceType(Class<? extends HasMetadata> customResource) {
        try {
            HasMetadata instance = customResource.newInstance();
            String kind = Utils.isNullOrEmpty(instance.getKind()) ? customResource.getSimpleName() : instance.getKind();
            String name = kind.toLowerCase();
            String plural = Pluralize.toPlural(name);
            String group = ApiVersionUtil.apiGroup(instance, null);
            String version = ApiVersionUtil.apiVersion(instance, "v1");
            String scope = instance instanceof Namespaced ? "Namespaced" : "Cluster";
            return new Builder().withGroup(group).withVersion(version).withScope(scope).withName(name).withPlural(plural).withKind(kind).build();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static CustomResourceDefinitionContext fromCrd(CustomResourceDefinition crd) {
        return new Builder().withGroup(crd.getSpec().getGroup()).withVersion(crd.getSpec().getVersion()).withScope(crd.getSpec().getScope()).withName(crd.getMetadata().getName()).withPlural(crd.getSpec().getNames().getPlural()).withKind(crd.getSpec().getNames().getKind()).build();
    }

    public static class Builder {
        private final CustomResourceDefinitionContext customResourceDefinitionContext = new CustomResourceDefinitionContext();

        public Builder withName(String name) {
            this.customResourceDefinitionContext.name = name;
            return this;
        }

        public Builder withGroup(String group) {
            this.customResourceDefinitionContext.group = group;
            return this;
        }

        public Builder withScope(String scope) {
            this.customResourceDefinitionContext.scope = scope;
            return this;
        }

        public Builder withPlural(String plural) {
            this.customResourceDefinitionContext.plural = plural;
            return this;
        }

        public Builder withVersion(String version) {
            this.customResourceDefinitionContext.version = version;
            return this;
        }

        public Builder withKind(String kind) {
            this.customResourceDefinitionContext.kind = kind;
            return this;
        }

        public CustomResourceDefinitionContext build() {
            return this.customResourceDefinitionContext;
        }
    }
}

