/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_0.handlers;

import io.fabric8.kubernetes.api.model.v5_0.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_0.ListOptions;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_0.Watch;
import io.fabric8.kubernetes.clnt.v5_0.Watcher;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Resource;
import io.fabric8.openshift.api.model.v5_0.Group;
import io.fabric8.openshift.api.model.v5_0.GroupBuilder;
import io.fabric8.openshift.clnt.v5_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_0.dsl.internal.GroupOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class GroupHandler
implements ResourceHandler<Group, GroupBuilder> {
    @Override
    public String getKind() {
        return Group.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "user.openshift.io/v1";
    }

    @Override
    public Group create(OkHttpClient client, Config config, String namespace, Group item) {
        return (Group)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Group[0]);
    }

    @Override
    public Group replace(OkHttpClient client, Config config, String namespace, Group item) {
        return ((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Group reload(OkHttpClient client, Config config, String namespace, Group item) {
        return (Group)((Gettable)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public GroupBuilder edit(Group item) {
        return new GroupBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Group item) {
        return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Group item, Watcher<Group> watcher) {
        return ((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Group item, String resourceVersion, Watcher<Group> watcher) {
        return ((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Group item, ListOptions options, Watcher<Group> watcher) {
        return ((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Group waitUntilReady(OkHttpClient client, Config config, String namespace, Group item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Group)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Group waitUntilCondition(OkHttpClient client, Config config, String namespace, Group item, Predicate<Group> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Group)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

