/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_0.handlers;

import io.fabric8.kubernetes.api.model.v5_0.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_0.ListOptions;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_0.Watch;
import io.fabric8.kubernetes.clnt.v5_0.Watcher;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Resource;
import io.fabric8.openshift.api.model.v5_0.ClusterNetwork;
import io.fabric8.openshift.api.model.v5_0.ClusterNetworkBuilder;
import io.fabric8.openshift.clnt.v5_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_0.dsl.internal.ClusterNetworkOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterNetworkHandler
implements ResourceHandler<ClusterNetwork, ClusterNetworkBuilder> {
    @Override
    public String getKind() {
        return ClusterNetwork.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "network.openshift.io/v1";
    }

    @Override
    public ClusterNetwork create(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
        return (ClusterNetwork)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new ClusterNetwork[0]);
    }

    @Override
    public ClusterNetwork replace(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
        return ((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ClusterNetwork reload(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
        return (ClusterNetwork)((Gettable)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ClusterNetworkBuilder edit(ClusterNetwork item) {
        return new ClusterNetworkBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterNetwork item) {
        return new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, Watcher<ClusterNetwork> watcher) {
        return ((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, String resourceVersion, Watcher<ClusterNetwork> watcher) {
        return ((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, ListOptions options, Watcher<ClusterNetwork> watcher) {
        return ((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ClusterNetwork waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterNetwork item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterNetwork)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ClusterNetwork waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterNetwork item, Predicate<ClusterNetwork> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterNetwork)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

