/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_0.Nested;
import io.fabric8.kubernetes.api.builder.v5_0.Predicate;
import io.fabric8.kubernetes.api.model.v5_0.Affinity;
import io.fabric8.kubernetes.api.model.v5_0.Container;
import io.fabric8.kubernetes.api.model.v5_0.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v5_0.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v5_0.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_0.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.PodSecurityContext;
import io.fabric8.kubernetes.api.model.v5_0.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v5_0.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v5_0.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.Toleration;
import io.fabric8.kubernetes.api.model.v5_0.Volume;
import io.fabric8.kubernetes.api.model.v5_0.VolumeMount;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.AlertmanagerSpec;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.AlertmanagerSpecFluent;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.EmbeddedObjectMetadata;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.EmbeddedObjectMetadataBuilder;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.EmbeddedObjectMetadataFluentImpl;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.StorageSpec;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.StorageSpecBuilder;
import io.fabric8.openshift.api.model.v5_0.monitoring.v1.StorageSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AlertmanagerSpecFluentImpl<A extends AlertmanagerSpecFluent<A>>
extends BaseFluent<A>
implements AlertmanagerSpecFluent<A> {
    private List<String> additionalPeers = new ArrayList<String>();
    private Affinity affinity;
    private String baseImage;
    private String clusterAdvertiseAddress;
    private List<String> configMaps = new ArrayList<String>();
    private String configSecret;
    private List<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
    private String externalUrl;
    private String image;
    private List<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
    private List<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private Map<String, String> nodeSelector;
    private Boolean paused;
    private EmbeddedObjectMetadataBuilder podMetadata;
    private String portName;
    private String priorityClassName;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;
    private String retention;
    private String routePrefix;
    private List<String> secrets = new ArrayList<String>();
    private PodSecurityContext securityContext;
    private String serviceAccountName;
    private String sha;
    private StorageSpecBuilder storage;
    private String tag;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private String version;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();

    public AlertmanagerSpecFluentImpl() {
    }

    public AlertmanagerSpecFluentImpl(AlertmanagerSpec instance) {
        this.withAdditionalPeers(instance.getAdditionalPeers());
        this.withAffinity(instance.getAffinity());
        this.withBaseImage(instance.getBaseImage());
        this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress());
        this.withConfigMaps(instance.getConfigMaps());
        this.withConfigSecret(instance.getConfigSecret());
        this.withContainers(instance.getContainers());
        this.withExternalUrl(instance.getExternalUrl());
        this.withImage(instance.getImage());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withInitContainers(instance.getInitContainers());
        this.withListenLocal(instance.getListenLocal());
        this.withLogFormat(instance.getLogFormat());
        this.withLogLevel(instance.getLogLevel());
        this.withNodeSelector(instance.getNodeSelector());
        this.withPaused(instance.getPaused());
        this.withPodMetadata(instance.getPodMetadata());
        this.withPortName(instance.getPortName());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withReplicas(instance.getReplicas());
        this.withResources(instance.getResources());
        this.withRetention(instance.getRetention());
        this.withRoutePrefix(instance.getRoutePrefix());
        this.withSecrets(instance.getSecrets());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSha(instance.getSha());
        this.withStorage(instance.getStorage());
        this.withTag(instance.getTag());
        this.withTolerations(instance.getTolerations());
        this.withVersion(instance.getVersion());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public A addToAdditionalPeers(int index, String item) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        this.additionalPeers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalPeers(int index, String item) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        this.additionalPeers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalPeers(String ... items) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalPeers(Collection<String> items) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalPeers(String ... items) {
        for (String item : items) {
            if (this.additionalPeers == null) continue;
            this.additionalPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalPeers(Collection<String> items) {
        for (String item : items) {
            if (this.additionalPeers == null) continue;
            this.additionalPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdditionalPeers() {
        return this.additionalPeers;
    }

    @Override
    public String getAdditionalPeer(int index) {
        return this.additionalPeers.get(index);
    }

    @Override
    public String getFirstAdditionalPeer() {
        return this.additionalPeers.get(0);
    }

    @Override
    public String getLastAdditionalPeer() {
        return this.additionalPeers.get(this.additionalPeers.size() - 1);
    }

    @Override
    public String getMatchingAdditionalPeer(Predicate<String> predicate) {
        for (String item : this.additionalPeers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalPeer(Predicate<String> predicate) {
        for (String item : this.additionalPeers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalPeers(List<String> additionalPeers) {
        if (this.additionalPeers != null) {
            this._visitables.get("additionalPeers").removeAll(this.additionalPeers);
        }
        if (additionalPeers != null) {
            this.additionalPeers = new ArrayList<String>();
            for (String item : additionalPeers) {
                this.addToAdditionalPeers(item);
            }
        } else {
            this.additionalPeers = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalPeers(String ... additionalPeers) {
        if (this.additionalPeers != null) {
            this.additionalPeers.clear();
        }
        if (additionalPeers != null) {
            for (String item : additionalPeers) {
                this.addToAdditionalPeers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalPeers() {
        return this.additionalPeers != null && !this.additionalPeers.isEmpty();
    }

    @Override
    public A addNewAdditionalPeer(String arg1) {
        return this.addToAdditionalPeers(new String(arg1));
    }

    @Override
    public A addNewAdditionalPeer(StringBuilder arg1) {
        return this.addToAdditionalPeers(new String(arg1));
    }

    @Override
    public A addNewAdditionalPeer(StringBuffer arg1) {
        return this.addToAdditionalPeers(new String(arg1));
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    @Override
    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    @Override
    public A withNewBaseImage(String arg1) {
        return this.withBaseImage(new String(arg1));
    }

    @Override
    public A withNewBaseImage(StringBuilder arg1) {
        return this.withBaseImage(new String(arg1));
    }

    @Override
    public A withNewBaseImage(StringBuffer arg1) {
        return this.withBaseImage(new String(arg1));
    }

    @Override
    public String getClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress;
    }

    @Override
    public A withClusterAdvertiseAddress(String clusterAdvertiseAddress) {
        this.clusterAdvertiseAddress = clusterAdvertiseAddress;
        return (A)this;
    }

    @Override
    public Boolean hasClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress != null;
    }

    @Override
    public A withNewClusterAdvertiseAddress(String arg1) {
        return this.withClusterAdvertiseAddress(new String(arg1));
    }

    @Override
    public A withNewClusterAdvertiseAddress(StringBuilder arg1) {
        return this.withClusterAdvertiseAddress(new String(arg1));
    }

    @Override
    public A withNewClusterAdvertiseAddress(StringBuffer arg1) {
        return this.withClusterAdvertiseAddress(new String(arg1));
    }

    @Override
    public A addToConfigMaps(int index, String item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        this.configMaps.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConfigMaps(int index, String item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        this.configMaps.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConfigMaps(String ... items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configMaps.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigMaps(Collection<String> items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configMaps.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfigMaps(String ... items) {
        for (String item : items) {
            if (this.configMaps == null) continue;
            this.configMaps.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigMaps(Collection<String> items) {
        for (String item : items) {
            if (this.configMaps == null) continue;
            this.configMaps.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getConfigMaps() {
        return this.configMaps;
    }

    @Override
    public String getConfigMap(int index) {
        return this.configMaps.get(index);
    }

    @Override
    public String getFirstConfigMap() {
        return this.configMaps.get(0);
    }

    @Override
    public String getLastConfigMap() {
        return this.configMaps.get(this.configMaps.size() - 1);
    }

    @Override
    public String getMatchingConfigMap(Predicate<String> predicate) {
        for (String item : this.configMaps) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfigMap(Predicate<String> predicate) {
        for (String item : this.configMaps) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConfigMaps(List<String> configMaps) {
        if (this.configMaps != null) {
            this._visitables.get("configMaps").removeAll(this.configMaps);
        }
        if (configMaps != null) {
            this.configMaps = new ArrayList<String>();
            for (String item : configMaps) {
                this.addToConfigMaps(item);
            }
        } else {
            this.configMaps = null;
        }
        return (A)this;
    }

    @Override
    public A withConfigMaps(String ... configMaps) {
        if (this.configMaps != null) {
            this.configMaps.clear();
        }
        if (configMaps != null) {
            for (String item : configMaps) {
                this.addToConfigMaps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMaps() {
        return this.configMaps != null && !this.configMaps.isEmpty();
    }

    @Override
    public A addNewConfigMap(String arg1) {
        return this.addToConfigMaps(new String(arg1));
    }

    @Override
    public A addNewConfigMap(StringBuilder arg1) {
        return this.addToConfigMaps(new String(arg1));
    }

    @Override
    public A addNewConfigMap(StringBuffer arg1) {
        return this.addToConfigMaps(new String(arg1));
    }

    @Override
    public String getConfigSecret() {
        return this.configSecret;
    }

    @Override
    public A withConfigSecret(String configSecret) {
        this.configSecret = configSecret;
        return (A)this;
    }

    @Override
    public Boolean hasConfigSecret() {
        return this.configSecret != null;
    }

    @Override
    public A withNewConfigSecret(String arg1) {
        return this.withConfigSecret(new String(arg1));
    }

    @Override
    public A withNewConfigSecret(StringBuilder arg1) {
        return this.withConfigSecret(new String(arg1));
    }

    @Override
    public A withNewConfigSecret(StringBuffer arg1) {
        return this.withConfigSecret(new String(arg1));
    }

    @Override
    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get("containers").add(index >= 0 ? index : this._visitables.get("containers").size(), builder);
        this.containers.add(index >= 0 ? index : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("containers").size()) {
            this._visitables.get("containers").add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getContainers() {
        return AlertmanagerSpecFluentImpl.build(this.containers);
    }

    @Override
    public List<Container> buildContainers() {
        return AlertmanagerSpecFluentImpl.build(this.containers);
    }

    @Override
    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<ContainerBuilder>();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.apply(this.containers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Override
    public A withExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return (A)this;
    }

    @Override
    public Boolean hasExternalUrl() {
        return this.externalUrl != null;
    }

    @Override
    public A withNewExternalUrl(String arg1) {
        return this.withExternalUrl(new String(arg1));
    }

    @Override
    public A withNewExternalUrl(StringBuilder arg1) {
        return this.withExternalUrl(new String(arg1));
    }

    @Override
    public A withNewExternalUrl(StringBuffer arg1) {
        return this.withExternalUrl(new String(arg1));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        this._visitables.get("imagePullSecrets").add(index >= 0 ? index : this._visitables.get("imagePullSecrets").size(), builder);
        this.imagePullSecrets.add(index >= 0 ? index : this.imagePullSecrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("imagePullSecrets").size()) {
            this._visitables.get("imagePullSecrets").add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
        }
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this.imagePullSecrets.add(builder);
        } else {
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LocalObjectReference> getImagePullSecrets() {
        return AlertmanagerSpecFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public List<LocalObjectReference> buildImagePullSecrets() {
        return AlertmanagerSpecFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.apply(this.imagePullSecrets.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get("initContainers").add(index >= 0 ? index : this._visitables.get("initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("initContainers").size()) {
            this._visitables.get("initContainers").add(builder);
        } else {
            this._visitables.get("initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        Object visitables = this._visitables.get("initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getInitContainers() {
        return AlertmanagerSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public List<Container> buildInitContainers() {
        return AlertmanagerSpecFluentImpl.build(this.initContainers);
    }

    @Override
    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get("initContainers").removeAll(this.initContainers);
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public AlertmanagerSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.apply(this.initContainers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public Boolean isListenLocal() {
        return this.listenLocal;
    }

    @Override
    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
        return (A)this;
    }

    @Override
    public Boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    @Override
    public A withNewListenLocal(String arg1) {
        return this.withListenLocal(new Boolean(arg1));
    }

    @Override
    public A withNewListenLocal(boolean arg1) {
        return this.withListenLocal(new Boolean(arg1));
    }

    @Override
    public String getLogFormat() {
        return this.logFormat;
    }

    @Override
    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)this;
    }

    @Override
    public Boolean hasLogFormat() {
        return this.logFormat != null;
    }

    @Override
    public A withNewLogFormat(String arg1) {
        return this.withLogFormat(new String(arg1));
    }

    @Override
    public A withNewLogFormat(StringBuilder arg1) {
        return this.withLogFormat(new String(arg1));
    }

    @Override
    public A withNewLogFormat(StringBuffer arg1) {
        return this.withLogFormat(new String(arg1));
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public A withNewLogLevel(String arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A withNewLogLevel(StringBuilder arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A withNewLogLevel(StringBuffer arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public Boolean isPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Boolean hasPaused() {
        return this.paused != null;
    }

    @Override
    public A withNewPaused(String arg1) {
        return this.withPaused(new Boolean(arg1));
    }

    @Override
    public A withNewPaused(boolean arg1) {
        return this.withPaused(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public EmbeddedObjectMetadata getPodMetadata() {
        return this.podMetadata != null ? this.podMetadata.build() : null;
    }

    @Override
    public EmbeddedObjectMetadata buildPodMetadata() {
        return this.podMetadata != null ? this.podMetadata.build() : null;
    }

    @Override
    public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
        this._visitables.get("podMetadata").remove(this.podMetadata);
        if (podMetadata != null) {
            this.podMetadata = new EmbeddedObjectMetadataBuilder(podMetadata);
            this._visitables.get("podMetadata").add(this.podMetadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodMetadata() {
        return this.podMetadata != null;
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadata() {
        return new PodMetadataNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return new PodMetadataNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> editPodMetadata() {
        return this.withNewPodMetadataLike(this.getPodMetadata());
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadata() {
        return this.withNewPodMetadataLike(this.getPodMetadata() != null ? this.getPodMetadata() : new EmbeddedObjectMetadataBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return this.withNewPodMetadataLike(this.getPodMetadata() != null ? this.getPodMetadata() : item);
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    @Override
    public A withPortName(String portName) {
        this.portName = portName;
        return (A)this;
    }

    @Override
    public Boolean hasPortName() {
        return this.portName != null;
    }

    @Override
    public A withNewPortName(String arg1) {
        return this.withPortName(new String(arg1));
    }

    @Override
    public A withNewPortName(StringBuilder arg1) {
        return this.withPortName(new String(arg1));
    }

    @Override
    public A withNewPortName(StringBuffer arg1) {
        return this.withPortName(new String(arg1));
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public A withNewPriorityClassName(String arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuilder arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuffer arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public String getRetention() {
        return this.retention;
    }

    @Override
    public A withRetention(String retention) {
        this.retention = retention;
        return (A)this;
    }

    @Override
    public Boolean hasRetention() {
        return this.retention != null;
    }

    @Override
    public A withNewRetention(String arg1) {
        return this.withRetention(new String(arg1));
    }

    @Override
    public A withNewRetention(StringBuilder arg1) {
        return this.withRetention(new String(arg1));
    }

    @Override
    public A withNewRetention(StringBuffer arg1) {
        return this.withRetention(new String(arg1));
    }

    @Override
    public String getRoutePrefix() {
        return this.routePrefix;
    }

    @Override
    public A withRoutePrefix(String routePrefix) {
        this.routePrefix = routePrefix;
        return (A)this;
    }

    @Override
    public Boolean hasRoutePrefix() {
        return this.routePrefix != null;
    }

    @Override
    public A withNewRoutePrefix(String arg1) {
        return this.withRoutePrefix(new String(arg1));
    }

    @Override
    public A withNewRoutePrefix(StringBuilder arg1) {
        return this.withRoutePrefix(new String(arg1));
    }

    @Override
    public A withNewRoutePrefix(StringBuffer arg1) {
        return this.withRoutePrefix(new String(arg1));
    }

    @Override
    public A addToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSecrets(String ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(String ... items) {
        for (String item : items) {
            if (this.secrets == null) continue;
            this.secrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<String> items) {
        for (String item : items) {
            if (this.secrets == null) continue;
            this.secrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSecrets() {
        return this.secrets;
    }

    @Override
    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    @Override
    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    @Override
    public String getLastSecret() {
        return this.secrets.get(this.secrets.size() - 1);
    }

    @Override
    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<String> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").removeAll(this.secrets);
        }
        if (secrets != null) {
            this.secrets = new ArrayList<String>();
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(String ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
        }
        if (secrets != null) {
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public A addNewSecret(String arg1) {
        return this.addToSecrets(new String(arg1));
    }

    @Override
    public A addNewSecret(StringBuilder arg1) {
        return this.addToSecrets(new String(arg1));
    }

    @Override
    public A addNewSecret(StringBuffer arg1) {
        return this.addToSecrets(new String(arg1));
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public A withNewServiceAccountName(String arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuilder arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuffer arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public String getSha() {
        return this.sha;
    }

    @Override
    public A withSha(String sha) {
        this.sha = sha;
        return (A)this;
    }

    @Override
    public Boolean hasSha() {
        return this.sha != null;
    }

    @Override
    public A withNewSha(String arg1) {
        return this.withSha(new String(arg1));
    }

    @Override
    public A withNewSha(StringBuilder arg1) {
        return this.withSha(new String(arg1));
    }

    @Override
    public A withNewSha(StringBuffer arg1) {
        return this.withSha(new String(arg1));
    }

    @Override
    @Deprecated
    public StorageSpec getStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public StorageSpec buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public A withStorage(StorageSpec storage) {
        this._visitables.get("storage").remove(this.storage);
        if (storage != null) {
            this.storage = new StorageSpecBuilder(storage);
            this._visitables.get("storage").add(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> withNewStorage() {
        return new StorageNestedImpl();
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item) {
        return new StorageNestedImpl(item);
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> editStorage() {
        return this.withNewStorageLike(this.getStorage());
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : new StorageSpecBuilder().build());
    }

    @Override
    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item) {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : item);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    @Override
    public Boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public A withNewTag(String arg1) {
        return this.withTag(new String(arg1));
    }

    @Override
    public A withNewTag(StringBuilder arg1) {
        return this.withTag(new String(arg1));
    }

    @Override
    public A withNewTag(StringBuffer arg1) {
        return this.withTag(new String(arg1));
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A withNewVersion(String arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuilder arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuffer arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    @Override
    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    @Override
    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    @Override
    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1);
    }

    @Override
    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").removeAll(this.volumeMounts);
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public Volume getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<Volume>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertmanagerSpecFluentImpl that = (AlertmanagerSpecFluentImpl)o;
        if (this.additionalPeers != null ? !this.additionalPeers.equals(that.additionalPeers) : that.additionalPeers != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.baseImage != null ? !this.baseImage.equals(that.baseImage) : that.baseImage != null) {
            return false;
        }
        if (this.clusterAdvertiseAddress != null ? !this.clusterAdvertiseAddress.equals(that.clusterAdvertiseAddress) : that.clusterAdvertiseAddress != null) {
            return false;
        }
        if (this.configMaps != null ? !this.configMaps.equals(that.configMaps) : that.configMaps != null) {
            return false;
        }
        if (this.configSecret != null ? !this.configSecret.equals(that.configSecret) : that.configSecret != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.externalUrl != null ? !this.externalUrl.equals(that.externalUrl) : that.externalUrl != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.listenLocal != null ? !this.listenLocal.equals(that.listenLocal) : that.listenLocal != null) {
            return false;
        }
        if (this.logFormat != null ? !this.logFormat.equals(that.logFormat) : that.logFormat != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.paused != null ? !this.paused.equals(that.paused) : that.paused != null) {
            return false;
        }
        if (this.podMetadata != null ? !this.podMetadata.equals(that.podMetadata) : that.podMetadata != null) {
            return false;
        }
        if (this.portName != null ? !this.portName.equals(that.portName) : that.portName != null) {
            return false;
        }
        if (this.priorityClassName != null ? !this.priorityClassName.equals(that.priorityClassName) : that.priorityClassName != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.retention != null ? !this.retention.equals(that.retention) : that.retention != null) {
            return false;
        }
        if (this.routePrefix != null ? !this.routePrefix.equals(that.routePrefix) : that.routePrefix != null) {
            return false;
        }
        if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.sha != null ? !this.sha.equals(that.sha) : that.sha != null) {
            return false;
        }
        if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public int hashCode() {
        return Objects.hash(this.additionalPeers, this.affinity, this.baseImage, this.clusterAdvertiseAddress, this.configMaps, this.configSecret, this.containers, this.externalUrl, this.image, this.imagePullSecrets, this.initContainers, this.listenLocal, this.logFormat, this.logLevel, this.nodeSelector, this.paused, this.podMetadata, this.portName, this.priorityClassName, this.replicas, this.resources, this.retention, this.routePrefix, this.secrets, this.securityContext, this.serviceAccountName, this.sha, this.storage, this.tag, this.tolerations, this.version, this.volumeMounts, this.volumes, super.hashCode());
    }

    public class StorageNestedImpl<N>
    extends StorageSpecFluentImpl<AlertmanagerSpecFluent.StorageNested<N>>
    implements AlertmanagerSpecFluent.StorageNested<N>,
    Nested<N> {
        private final StorageSpecBuilder builder;

        StorageNestedImpl(StorageSpec item) {
            this.builder = new StorageSpecBuilder(this, item);
        }

        StorageNestedImpl() {
            this.builder = new StorageSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withStorage(this.builder.build());
        }

        @Override
        public N endStorage() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<AlertmanagerSpecFluent.ResourcesNested<N>>
    implements AlertmanagerSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class PodMetadataNestedImpl<N>
    extends EmbeddedObjectMetadataFluentImpl<AlertmanagerSpecFluent.PodMetadataNested<N>>
    implements AlertmanagerSpecFluent.PodMetadataNested<N>,
    Nested<N> {
        private final EmbeddedObjectMetadataBuilder builder;

        PodMetadataNestedImpl(EmbeddedObjectMetadata item) {
            this.builder = new EmbeddedObjectMetadataBuilder(this, item);
        }

        PodMetadataNestedImpl() {
            this.builder = new EmbeddedObjectMetadataBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.withPodMetadata(this.builder.build());
        }

        @Override
        public N endPodMetadata() {
            return this.and();
        }
    }

    public class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<AlertmanagerSpecFluent.InitContainersNested<N>>
    implements AlertmanagerSpecFluent.InitContainersNested<N>,
    Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        InitContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<AlertmanagerSpecFluent.ImagePullSecretsNested<N>>
    implements AlertmanagerSpecFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;
        private final int index;

        ImagePullSecretsNestedImpl(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends ContainerFluentImpl<AlertmanagerSpecFluent.ContainersNested<N>>
    implements AlertmanagerSpecFluent.ContainersNested<N>,
    Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        ContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

