/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_0.Nested;
import io.fabric8.kubernetes.api.builder.v5_0.Predicate;
import io.fabric8.openshift.api.model.v5_0.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v5_0.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v5_0.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_0.ProxySpec;
import io.fabric8.openshift.api.model.v5_0.ProxySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ProxySpecFluentImpl<A extends ProxySpecFluent<A>>
extends BaseFluent<A>
implements ProxySpecFluent<A> {
    private String httpProxy;
    private String httpsProxy;
    private String noProxy;
    private List<String> readinessEndpoints = new ArrayList<String>();
    private ConfigMapNameReferenceBuilder trustedCA;

    public ProxySpecFluentImpl() {
    }

    public ProxySpecFluentImpl(ProxySpec instance) {
        this.withHttpProxy(instance.getHttpProxy());
        this.withHttpsProxy(instance.getHttpsProxy());
        this.withNoProxy(instance.getNoProxy());
        this.withReadinessEndpoints(instance.getReadinessEndpoints());
        this.withTrustedCA(instance.getTrustedCA());
    }

    @Override
    public String getHttpProxy() {
        return this.httpProxy;
    }

    @Override
    public A withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return (A)this;
    }

    @Override
    public Boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    @Override
    public A withNewHttpProxy(String arg1) {
        return this.withHttpProxy(new String(arg1));
    }

    @Override
    public A withNewHttpProxy(StringBuilder arg1) {
        return this.withHttpProxy(new String(arg1));
    }

    @Override
    public A withNewHttpProxy(StringBuffer arg1) {
        return this.withHttpProxy(new String(arg1));
    }

    @Override
    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    @Override
    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return (A)this;
    }

    @Override
    public Boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    @Override
    public A withNewHttpsProxy(String arg1) {
        return this.withHttpsProxy(new String(arg1));
    }

    @Override
    public A withNewHttpsProxy(StringBuilder arg1) {
        return this.withHttpsProxy(new String(arg1));
    }

    @Override
    public A withNewHttpsProxy(StringBuffer arg1) {
        return this.withHttpsProxy(new String(arg1));
    }

    @Override
    public String getNoProxy() {
        return this.noProxy;
    }

    @Override
    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    @Override
    public Boolean hasNoProxy() {
        return this.noProxy != null;
    }

    @Override
    public A withNewNoProxy(String arg1) {
        return this.withNoProxy(new String(arg1));
    }

    @Override
    public A withNewNoProxy(StringBuilder arg1) {
        return this.withNoProxy(new String(arg1));
    }

    @Override
    public A withNewNoProxy(StringBuffer arg1) {
        return this.withNoProxy(new String(arg1));
    }

    @Override
    public A addToReadinessEndpoints(int index, String item) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        this.readinessEndpoints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToReadinessEndpoints(int index, String item) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        this.readinessEndpoints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToReadinessEndpoints(String ... items) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.readinessEndpoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToReadinessEndpoints(Collection<String> items) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.readinessEndpoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromReadinessEndpoints(String ... items) {
        for (String item : items) {
            if (this.readinessEndpoints == null) continue;
            this.readinessEndpoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReadinessEndpoints(Collection<String> items) {
        for (String item : items) {
            if (this.readinessEndpoints == null) continue;
            this.readinessEndpoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getReadinessEndpoints() {
        return this.readinessEndpoints;
    }

    @Override
    public String getReadinessEndpoint(int index) {
        return this.readinessEndpoints.get(index);
    }

    @Override
    public String getFirstReadinessEndpoint() {
        return this.readinessEndpoints.get(0);
    }

    @Override
    public String getLastReadinessEndpoint() {
        return this.readinessEndpoints.get(this.readinessEndpoints.size() - 1);
    }

    @Override
    public String getMatchingReadinessEndpoint(Predicate<String> predicate) {
        for (String item : this.readinessEndpoints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReadinessEndpoint(Predicate<String> predicate) {
        for (String item : this.readinessEndpoints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReadinessEndpoints(List<String> readinessEndpoints) {
        if (this.readinessEndpoints != null) {
            this._visitables.get("readinessEndpoints").removeAll(this.readinessEndpoints);
        }
        if (readinessEndpoints != null) {
            this.readinessEndpoints = new ArrayList<String>();
            for (String item : readinessEndpoints) {
                this.addToReadinessEndpoints(item);
            }
        } else {
            this.readinessEndpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withReadinessEndpoints(String ... readinessEndpoints) {
        if (this.readinessEndpoints != null) {
            this.readinessEndpoints.clear();
        }
        if (readinessEndpoints != null) {
            for (String item : readinessEndpoints) {
                this.addToReadinessEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessEndpoints() {
        return this.readinessEndpoints != null && !this.readinessEndpoints.isEmpty();
    }

    @Override
    public A addNewReadinessEndpoint(String arg1) {
        return this.addToReadinessEndpoints(new String(arg1));
    }

    @Override
    public A addNewReadinessEndpoint(StringBuilder arg1) {
        return this.addToReadinessEndpoints(new String(arg1));
    }

    @Override
    public A addNewReadinessEndpoint(StringBuffer arg1) {
        return this.addToReadinessEndpoints(new String(arg1));
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getTrustedCA() {
        return this.trustedCA != null ? this.trustedCA.build() : null;
    }

    @Override
    public ConfigMapNameReference buildTrustedCA() {
        return this.trustedCA != null ? this.trustedCA.build() : null;
    }

    @Override
    public A withTrustedCA(ConfigMapNameReference trustedCA) {
        this._visitables.get("trustedCA").remove(this.trustedCA);
        if (trustedCA != null) {
            this.trustedCA = new ConfigMapNameReferenceBuilder(trustedCA);
            this._visitables.get("trustedCA").add(this.trustedCA);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTrustedCA() {
        return this.trustedCA != null;
    }

    @Override
    public A withNewTrustedCA(String name) {
        return this.withTrustedCA(new ConfigMapNameReference(name));
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> withNewTrustedCA() {
        return new TrustedCANestedImpl();
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> withNewTrustedCALike(ConfigMapNameReference item) {
        return new TrustedCANestedImpl(item);
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> editTrustedCA() {
        return this.withNewTrustedCALike(this.getTrustedCA());
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCA() {
        return this.withNewTrustedCALike(this.getTrustedCA() != null ? this.getTrustedCA() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCALike(ConfigMapNameReference item) {
        return this.withNewTrustedCALike(this.getTrustedCA() != null ? this.getTrustedCA() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySpecFluentImpl that = (ProxySpecFluentImpl)o;
        if (this.httpProxy != null ? !this.httpProxy.equals(that.httpProxy) : that.httpProxy != null) {
            return false;
        }
        if (this.httpsProxy != null ? !this.httpsProxy.equals(that.httpsProxy) : that.httpsProxy != null) {
            return false;
        }
        if (this.noProxy != null ? !this.noProxy.equals(that.noProxy) : that.noProxy != null) {
            return false;
        }
        if (this.readinessEndpoints != null ? !this.readinessEndpoints.equals(that.readinessEndpoints) : that.readinessEndpoints != null) {
            return false;
        }
        return !(this.trustedCA != null ? !this.trustedCA.equals(that.trustedCA) : that.trustedCA != null);
    }

    public int hashCode() {
        return Objects.hash(this.httpProxy, this.httpsProxy, this.noProxy, this.readinessEndpoints, this.trustedCA, super.hashCode());
    }

    public class TrustedCANestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<ProxySpecFluent.TrustedCANested<N>>
    implements ProxySpecFluent.TrustedCANested<N>,
    Nested<N> {
        private final ConfigMapNameReferenceBuilder builder;

        TrustedCANestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        TrustedCANestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProxySpecFluentImpl.this.withTrustedCA(this.builder.build());
        }

        @Override
        public N endTrustedCA() {
            return this.and();
        }
    }
}

