/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_0.Nested;
import io.fabric8.kubernetes.api.builder.v5_0.Predicate;
import io.fabric8.kubernetes.api.model.v5_0.ListMeta;
import io.fabric8.openshift.api.model.v5_0.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v5_0.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.v5_0.OAuthClientAuthorizationFluentImpl;
import io.fabric8.openshift.api.model.v5_0.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.v5_0.OAuthClientAuthorizationListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class OAuthClientAuthorizationListFluentImpl<A extends OAuthClientAuthorizationListFluent<A>>
extends BaseFluent<A>
implements OAuthClientAuthorizationListFluent<A> {
    private String apiVersion;
    private List<OAuthClientAuthorizationBuilder> items = new ArrayList<OAuthClientAuthorizationBuilder>();
    private String kind;
    private ListMeta metadata;

    public OAuthClientAuthorizationListFluentImpl() {
    }

    public OAuthClientAuthorizationListFluentImpl(OAuthClientAuthorizationList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, OAuthClientAuthorization item) {
        if (this.items == null) {
            this.items = new ArrayList<OAuthClientAuthorizationBuilder>();
        }
        OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, OAuthClientAuthorization item) {
        if (this.items == null) {
            this.items = new ArrayList<OAuthClientAuthorizationBuilder>();
        }
        OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(OAuthClientAuthorization ... items) {
        if (this.items == null) {
            this.items = new ArrayList<OAuthClientAuthorizationBuilder>();
        }
        for (OAuthClientAuthorization item : items) {
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<OAuthClientAuthorization> items) {
        if (this.items == null) {
            this.items = new ArrayList<OAuthClientAuthorizationBuilder>();
        }
        for (OAuthClientAuthorization item : items) {
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(OAuthClientAuthorization ... items) {
        for (OAuthClientAuthorization item : items) {
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<OAuthClientAuthorization> items) {
        for (OAuthClientAuthorization item : items) {
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<OAuthClientAuthorizationBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<OAuthClientAuthorizationBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            OAuthClientAuthorizationBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<OAuthClientAuthorization> getItems() {
        return OAuthClientAuthorizationListFluentImpl.build(this.items);
    }

    @Override
    public List<OAuthClientAuthorization> buildItems() {
        return OAuthClientAuthorizationListFluentImpl.build(this.items);
    }

    @Override
    public OAuthClientAuthorization buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public OAuthClientAuthorization buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public OAuthClientAuthorization buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public OAuthClientAuthorization buildMatchingItem(Predicate<OAuthClientAuthorizationBuilder> predicate) {
        for (OAuthClientAuthorizationBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<OAuthClientAuthorizationBuilder> predicate) {
        for (OAuthClientAuthorizationBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<OAuthClientAuthorization> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<OAuthClientAuthorizationBuilder>();
            for (OAuthClientAuthorization item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(OAuthClientAuthorization ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (OAuthClientAuthorization item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public OAuthClientAuthorizationListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public OAuthClientAuthorizationListFluent.ItemsNested<A> addNewItemLike(OAuthClientAuthorization item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public OAuthClientAuthorizationListFluent.ItemsNested<A> setNewItemLike(int index, OAuthClientAuthorization item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editMatchingItem(Predicate<OAuthClientAuthorizationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClientAuthorizationListFluentImpl that = (OAuthClientAuthorizationListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends OAuthClientAuthorizationFluentImpl<OAuthClientAuthorizationListFluent.ItemsNested<N>>
    implements OAuthClientAuthorizationListFluent.ItemsNested<N>,
    Nested<N> {
        private final OAuthClientAuthorizationBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, OAuthClientAuthorization item) {
            this.index = index;
            this.builder = new OAuthClientAuthorizationBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new OAuthClientAuthorizationBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthClientAuthorizationListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

