/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.informers.cache;

import io.fabric8.kubernetes.api.model.v5_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_0.Status;
import io.fabric8.kubernetes.clnt.v5_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_0.Watcher;
import io.fabric8.kubernetes.clnt.v5_0.informers.cache.Store;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectorWatcher<T extends HasMetadata>
implements Watcher<T> {
    private static final Logger log = LoggerFactory.getLogger(ReflectorWatcher.class);
    private final Store<T> store;
    private final AtomicReference<String> lastSyncResourceVersion;
    private final Runnable onClose;
    private final Runnable onHttpGone;

    public ReflectorWatcher(Store<T> store, AtomicReference<String> lastSyncResourceVersion, Runnable onClose, Runnable onHttpGone) {
        this.store = store;
        this.lastSyncResourceVersion = lastSyncResourceVersion;
        this.onClose = onClose;
        this.onHttpGone = onHttpGone;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        if (action == null) {
            String errorMessage = String.format("Unrecognized event %s", resource.getMetadata().getName());
            log.error(errorMessage);
            throw new KubernetesClientException(errorMessage);
        }
        log.info("Event received {}", (Object)action.name());
        switch (action) {
            case ERROR: {
                String errorMessage = String.format("ERROR event for %s", resource.getMetadata().getName());
                log.error(errorMessage);
                throw new KubernetesClientException(errorMessage);
            }
            case ADDED: {
                this.store.add(resource);
                break;
            }
            case MODIFIED: {
                this.store.update(resource);
                break;
            }
            case DELETED: {
                this.store.delete(resource);
            }
        }
        this.lastSyncResourceVersion.set(resource.getMetadata().getResourceVersion());
        log.debug("{}#Receiving resourceVersion {}", (Object)resource.getKind(), (Object)this.lastSyncResourceVersion.get());
    }

    @Override
    public void onClose(KubernetesClientException exception) {
        log.error("Watch closing");
        Optional.ofNullable(exception).map(e -> {
            log.debug("Exception received during watch", (Throwable)e);
            return exception;
        }).map(KubernetesClientException::getStatus).map(Status::getCode).filter(c -> c.equals(410)).ifPresent(c -> this.onHttpGone.run());
        this.onClose.run();
    }
}

