/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v5_0.APIService;
import io.fabric8.kubernetes.api.model.v5_0.APIServiceBuilder;
import io.fabric8.kubernetes.api.model.v5_0.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_0.ListOptions;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_0.Watch;
import io.fabric8.kubernetes.clnt.v5_0.Watcher;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_0.dsl.internal.core.v1.APIServiceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class APIServiceHandler
implements ResourceHandler<APIService, APIServiceBuilder> {
    @Override
    public String getKind() {
        return APIService.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apiregistration.k8s.io/v1";
    }

    @Override
    public APIService create(OkHttpClient client, Config config, String namespace, APIService item) {
        return (APIService)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new APIService[0]);
    }

    @Override
    public APIService replace(OkHttpClient client, Config config, String namespace, APIService item) {
        return ((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public APIService reload(OkHttpClient client, Config config, String namespace, APIService item) {
        return (APIService)((Gettable)((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public APIServiceBuilder edit(APIService item) {
        return new APIServiceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, APIService item) {
        return new APIServiceOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, Watcher<APIService> watcher) {
        return ((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, String resourceVersion, Watcher<APIService> watcher) {
        return ((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, ListOptions options, Watcher<APIService> watcher) {
        return ((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public APIService waitUntilReady(OkHttpClient client, Config config, String namespace, APIService item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIService)((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public APIService waitUntilCondition(OkHttpClient client, Config config, String namespace, APIService item, Predicate<APIService> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIService)((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

