/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.extended.run;

import io.fabric8.kubernetes.api.model.v5_0.Container;
import io.fabric8.kubernetes.api.model.v5_0.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v5_0.ContainerFluent;
import io.fabric8.kubernetes.api.model.v5_0.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.v5_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_0.PodSpec;
import io.fabric8.kubernetes.api.model.v5_0.PodSpecBuilder;
import io.fabric8.kubernetes.clnt.v5_0.extended.run.RunConfig;
import io.fabric8.kubernetes.clnt.v5_0.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.clnt.v5_0.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;

public class RunConfigUtil {
    private static final String DEFAULT_RESTART_POLICY = "Always";

    private RunConfigUtil() {
    }

    public static ObjectMeta getObjectMetadataFromRunConfig(RunConfig generatorRunConfig) {
        ObjectMetaBuilder objectMetaBuilder = new ObjectMetaBuilder();
        if (generatorRunConfig.getName() != null) {
            objectMetaBuilder.withName(generatorRunConfig.getName());
            objectMetaBuilder.addToLabels("run", generatorRunConfig.getName());
        }
        if (generatorRunConfig.getLabels() != null) {
            objectMetaBuilder.addToLabels(generatorRunConfig.getLabels());
        }
        return objectMetaBuilder.build();
    }

    public static PodSpec getPodSpecFromRunConfig(RunConfig generatorRunConfig) {
        PodSpecBuilder podSpecBuilder = new PodSpecBuilder();
        if (generatorRunConfig.getRestartPolicy() != null) {
            podSpecBuilder.withRestartPolicy(generatorRunConfig.getRestartPolicy());
        } else {
            podSpecBuilder.withRestartPolicy(DEFAULT_RESTART_POLICY);
        }
        if (generatorRunConfig.getServiceAccount() != null) {
            podSpecBuilder.withServiceAccountName(generatorRunConfig.getServiceAccount());
        }
        podSpecBuilder.addToContainers(RunConfigUtil.containerFromConfig(generatorRunConfig));
        return podSpecBuilder.build();
    }

    static Container containerFromConfig(RunConfig runConfig) {
        ContainerBuilder containerBuilder = new ContainerBuilder();
        containerBuilder.withName(runConfig.getName());
        containerBuilder.withImage(runConfig.getImage());
        containerBuilder.withImagePullPolicy(runConfig.getImagePullPolicy());
        containerBuilder.withArgs(RunConfigUtil.argsFromConfig(runConfig));
        containerBuilder.withCommand(RunConfigUtil.commandFromConfig(runConfig));
        if (runConfig.getEnv() != null) {
            containerBuilder.withEnv(KubernetesResourceUtil.convertMapToEnvVarList(runConfig.getEnv()));
        }
        if (runConfig.getPort() > 0) {
            containerBuilder.withPorts(((ContainerPortBuilder)new ContainerPortBuilder().withContainerPort(runConfig.getPort())).build());
        }
        if (runConfig.getLimits() != null) {
            ((ContainerFluent.ResourcesNested)containerBuilder.editOrNewResources().addToLimits(runConfig.getLimits())).endResources();
        }
        if (runConfig.getRequests() != null) {
            ((ContainerFluent.ResourcesNested)containerBuilder.editOrNewResources().addToRequests(runConfig.getRequests())).endResources();
        }
        return containerBuilder.build();
    }

    private static String[] argsFromConfig(RunConfig runConfig) {
        if (Utils.isNullOrEmpty(runConfig.getCommand()) && runConfig.getArgs() != null) {
            return runConfig.getArgs().toArray(new String[0]);
        }
        return new String[0];
    }

    private static String[] commandFromConfig(RunConfig runConfig) {
        if (Utils.isNotNullOrEmpty(runConfig.getCommand())) {
            ArrayList<String> command = new ArrayList<String>(Collections.singletonList(runConfig.getCommand()));
            if (runConfig.getArgs() != null) {
                command.addAll(runConfig.getArgs());
            }
            return command.toArray(new String[0]);
        }
        return new String[0];
    }
}

