/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_0.storage;

import io.fabric8.kubernetes.api.builder.v5_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_0.storage.VolumeAttachmentSource;
import io.fabric8.kubernetes.api.model.v5_0.storage.VolumeAttachmentSourceFluent;
import io.fabric8.kubernetes.api.model.v5_0.storage.VolumeAttachmentSourceFluentImpl;
import java.util.Objects;

public class VolumeAttachmentSourceBuilder
extends VolumeAttachmentSourceFluentImpl<VolumeAttachmentSourceBuilder>
implements VisitableBuilder<VolumeAttachmentSource, VolumeAttachmentSourceBuilder> {
    VolumeAttachmentSourceFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeAttachmentSourceBuilder() {
        this(true);
    }

    public VolumeAttachmentSourceBuilder(Boolean validationEnabled) {
        this(new VolumeAttachmentSource(), validationEnabled);
    }

    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeAttachmentSource(), validationEnabled);
    }

    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent, VolumeAttachmentSource instance) {
        this(fluent, instance, true);
    }

    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent, VolumeAttachmentSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withInlineVolumeSpec(instance.getInlineVolumeSpec());
        fluent.withPersistentVolumeName(instance.getPersistentVolumeName());
        this.validationEnabled = validationEnabled;
    }

    public VolumeAttachmentSourceBuilder(VolumeAttachmentSource instance) {
        this(instance, (Boolean)true);
    }

    public VolumeAttachmentSourceBuilder(VolumeAttachmentSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withInlineVolumeSpec(instance.getInlineVolumeSpec());
        this.withPersistentVolumeName(instance.getPersistentVolumeName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public VolumeAttachmentSource build() {
        VolumeAttachmentSource buildable = new VolumeAttachmentSource(this.fluent.getInlineVolumeSpec(), this.fluent.getPersistentVolumeName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeAttachmentSourceBuilder that = (VolumeAttachmentSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

