/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_0;

import io.fabric8.kubernetes.api.builder.v5_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_0.AttachedVolume;
import io.fabric8.kubernetes.api.model.v5_0.AttachedVolumeFluent;
import io.fabric8.kubernetes.api.model.v5_0.AttachedVolumeFluentImpl;
import java.util.Objects;

public class AttachedVolumeBuilder
extends AttachedVolumeFluentImpl<AttachedVolumeBuilder>
implements VisitableBuilder<AttachedVolume, AttachedVolumeBuilder> {
    AttachedVolumeFluent<?> fluent;
    Boolean validationEnabled;

    public AttachedVolumeBuilder() {
        this(true);
    }

    public AttachedVolumeBuilder(Boolean validationEnabled) {
        this(new AttachedVolume(), validationEnabled);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AttachedVolume(), validationEnabled);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent, AttachedVolume instance) {
        this(fluent, instance, true);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent, AttachedVolume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDevicePath(instance.getDevicePath());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public AttachedVolumeBuilder(AttachedVolume instance) {
        this(instance, (Boolean)true);
    }

    public AttachedVolumeBuilder(AttachedVolume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDevicePath(instance.getDevicePath());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AttachedVolume build() {
        AttachedVolume buildable = new AttachedVolume(this.fluent.getDevicePath(), this.fluent.getName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AttachedVolumeBuilder that = (AttachedVolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

