/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9.utils;

import io.fabric8.kubernetes.clnt.v4_9.Config;
import io.fabric8.kubernetes.clnt.v4_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_9.internal.SSLUtils;
import io.fabric8.kubernetes.clnt.v4_9.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.clnt.v4_9.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.clnt.v4_9.utils.IpAddressMatcher;
import io.fabric8.kubernetes.clnt.v4_9.utils.Utils;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static Pattern VALID_IPV4_PATTERN = null;
    public static final String ipv4Pattern = "(http:\\/\\/|https:\\/\\/)?(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])(\\/[0-9]\\d|1[0-9]\\d|2[0-9]\\d|3[0-2]\\d)?";
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);

    public static OkHttpClient createHttpClient(Config config) {
        return HttpClientUtils.createHttpClient(config, b -> {});
    }

    public static OkHttpClient createHttpClientForMockServer(Config config) {
        return HttpClientUtils.createHttpClient(config, b -> b.protocols(Collections.singletonList(Protocol.HTTP_1_1)));
    }

    private static OkHttpClient createHttpClient(Config config, Consumer<OkHttpClient.Builder> additionalConfig) {
        try {
            OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
            httpClientBuilder.followRedirects(true);
            httpClientBuilder.followSslRedirects(true);
            if (config.isTrustCerts() || config.isDisableHostnameVerification()) {
                httpClientBuilder.hostnameVerifier((s, sslSession) -> true);
            }
            TrustManager[] trustManagers = SSLUtils.trustManagers(config);
            KeyManager[] keyManagers = SSLUtils.keyManagers(config);
            if (keyManagers != null || trustManagers != null || config.isTrustCerts()) {
                X509TrustManager trustManager = null;
                if (trustManagers != null && trustManagers.length == 1) {
                    trustManager = (X509TrustManager)trustManagers[0];
                }
                try {
                    SSLContext sslContext = SSLUtils.sslContext(keyManagers, trustManagers);
                    httpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
                }
                catch (GeneralSecurityException e) {
                    throw new AssertionError();
                }
            } else {
                SSLContext context = SSLContext.getInstance("TLSv1.2");
                context.init(keyManagers, trustManagers, null);
                httpClientBuilder.sslSocketFactory(context.getSocketFactory(), (X509TrustManager)trustManagers[0]);
            }
            httpClientBuilder.addInterceptor(chain -> {
                Request request = chain.request();
                if (Utils.isNotNullOrEmpty(config.getUsername()) && Utils.isNotNullOrEmpty(config.getPassword())) {
                    Request authReq = chain.request().newBuilder().addHeader("Authorization", Credentials.basic((String)config.getUsername(), (String)config.getPassword())).build();
                    return chain.proceed(authReq);
                }
                if (Utils.isNotNullOrEmpty(config.getOauthToken())) {
                    Request authReq = chain.request().newBuilder().addHeader("Authorization", "Bearer " + config.getOauthToken()).build();
                    return chain.proceed(authReq);
                }
                return chain.proceed(request);
            }).addInterceptor((Interceptor)new ImpersonatorInterceptor(config)).addInterceptor((Interceptor)new BackwardsCompatibilityInterceptor());
            Logger reqLogger = LoggerFactory.getLogger(HttpLoggingInterceptor.class);
            if (reqLogger.isTraceEnabled()) {
                HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                httpClientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
            }
            if (config.getConnectionTimeout() > 0) {
                httpClientBuilder.connectTimeout((long)config.getConnectionTimeout(), TimeUnit.MILLISECONDS);
            }
            if (config.getRequestTimeout() > 0) {
                httpClientBuilder.readTimeout((long)config.getRequestTimeout(), TimeUnit.MILLISECONDS);
            }
            if (config.getWebsocketPingInterval() > 0L) {
                httpClientBuilder.pingInterval(config.getWebsocketPingInterval(), TimeUnit.MILLISECONDS);
            }
            if (config.getMaxConcurrentRequestsPerHost() > 0) {
                Dispatcher dispatcher = new Dispatcher();
                dispatcher.setMaxRequests(config.getMaxConcurrentRequests());
                dispatcher.setMaxRequestsPerHost(config.getMaxConcurrentRequestsPerHost());
                httpClientBuilder.dispatcher(dispatcher);
            }
            if (config.getMasterUrl().toLowerCase(Locale.ROOT).startsWith("http://") || config.getMasterUrl().startsWith("https://")) {
                try {
                    URL proxyUrl = HttpClientUtils.getProxyUrl(config);
                    if (proxyUrl != null) {
                        httpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort())));
                        if (config.getProxyUsername() != null) {
                            httpClientBuilder.proxyAuthenticator((route, response) -> {
                                String credential = Credentials.basic((String)config.getProxyUsername(), (String)config.getProxyPassword());
                                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                            });
                        }
                    }
                }
                catch (MalformedURLException e) {
                    throw new KubernetesClientException("Invalid proxy server configuration", e);
                }
            }
            if (config.getUserAgent() != null && !config.getUserAgent().isEmpty()) {
                httpClientBuilder.addNetworkInterceptor(chain -> {
                    Request agent = chain.request().newBuilder().header("User-Agent", config.getUserAgent()).build();
                    return chain.proceed(agent);
                });
            }
            if (config.getTlsVersions() != null && config.getTlsVersions().length > 0) {
                ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(config.getTlsVersions()).build();
                httpClientBuilder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
            }
            if (config.isHttp2Disable()) {
                httpClientBuilder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
            }
            if (additionalConfig != null) {
                additionalConfig.accept(httpClientBuilder);
            }
            if (config.getCustomHeaders() != null && !config.getCustomHeaders().isEmpty()) {
                httpClientBuilder.addNetworkInterceptor(chain -> {
                    Request.Builder agent = chain.request().newBuilder();
                    for (Map.Entry<String, String> entry : config.getCustomHeaders().entrySet()) {
                        agent.addHeader(entry.getKey(), entry.getValue());
                    }
                    return chain.proceed(agent.build());
                });
            }
            return httpClientBuilder.build();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static URL getProxyUrl(Config config) throws MalformedURLException {
        URL master = new URL(config.getMasterUrl());
        String host = master.getHost();
        if (config.getNoProxy() != null) {
            for (String noProxy : config.getNoProxy()) {
                if (!(HttpClientUtils.isIpAddress(noProxy) ? new IpAddressMatcher(noProxy).matches(host) : host.contains(noProxy))) continue;
                return null;
            }
        }
        String proxy = config.getHttpsProxy();
        if (master.getProtocol().equals("http")) {
            proxy = config.getHttpProxy();
        }
        if (proxy != null) {
            return new URL(proxy);
        }
        return null;
    }

    private static boolean isIpAddress(String ipAddress) {
        Matcher ipMatcher = VALID_IPV4_PATTERN.matcher(ipAddress);
        return ipMatcher.matches();
    }

    static {
        try {
            VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
        }
        catch (PatternSyntaxException e) {
            throw KubernetesClientException.launderThrowable("Unable to compile ipv4address pattern.", (Throwable)e);
        }
    }
}

