/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9.server.mock;

import io.fabric8.kubernetes.clnt.v4_9.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_9.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.clnt.v4_9.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.rules.ExternalResource;

public class KubernetesServer
extends ExternalResource {
    private KubernetesMockServer mock;
    private NamespacedKubernetesClient client;
    private boolean https;
    private boolean crudMode;

    public KubernetesServer() {
        this(true, false);
    }

    public KubernetesServer(boolean https) {
        this(https, false);
    }

    public KubernetesServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        this.mock = this.crudMode ? new KubernetesMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(), true) : new KubernetesMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createClient();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public NamespacedKubernetesClient getClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String method, String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String method, String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    public MockWebServer getMockServer() {
        return this.mock.getServer();
    }

    public RecordedRequest getLastRequest() throws InterruptedException {
        int count = this.mock.getServer().getRequestCount();
        RecordedRequest request = null;
        while (count-- > 0) {
            request = this.mock.getServer().takeRequest();
        }
        return request;
    }
}

