/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9.handlers;

import io.fabric8.kubernetes.api.model.v4_9.Namespace;
import io.fabric8.kubernetes.api.model.v4_9.NamespaceBuilder;
import io.fabric8.kubernetes.clnt.v4_9.Config;
import io.fabric8.kubernetes.clnt.v4_9.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_9.Watch;
import io.fabric8.kubernetes.clnt.v4_9.Watcher;
import io.fabric8.kubernetes.clnt.v4_9.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.NamespaceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NamespaceHandler
implements ResourceHandler<Namespace, NamespaceBuilder> {
    @Override
    public String getKind() {
        return Namespace.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Namespace create(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Namespace)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Namespace[0]);
    }

    @Override
    public Namespace replace(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Namespace reload(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Namespace)((Gettable)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NamespaceBuilder edit(Namespace item) {
        return new NamespaceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Namespace item) {
        return (Boolean)new NamespaceOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Namespace item, Watcher<Namespace> watcher) {
        return (Watch)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Namespace item, String resourceVersion, Watcher<Namespace> watcher) {
        return (Watch)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Namespace waitUntilReady(OkHttpClient client, Config config, String namespace, Namespace item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Namespace waitUntilCondition(OkHttpClient client, Config config, String namespace, Namespace item, Predicate<Namespace> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

