/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_9.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_9.authorization.DoneableLocalSubjectAccessReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.DoneableSelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.DoneableSelfSubjectRulesReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.DoneableSubjectAccessReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.LocalSubjectAccessReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.SelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.SelfSubjectRulesReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.SubjectAccessReview;
import io.fabric8.kubernetes.api.model.v4_9.authorization.SubjectAccessReviewSpec;
import io.fabric8.kubernetes.clnt.v4_9.Config;
import io.fabric8.kubernetes.clnt.v4_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_9.dsl.Createable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.SubjectAccessReviewDSL;
import io.fabric8.kubernetes.clnt.v4_9.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_9.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_9.utils.Utils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class SubjectAccessReviewDSLImpl
extends OperationSupport
implements SubjectAccessReviewDSL {
    private static final String AUTHORIZATION = "authorization.k8s.io/v1";
    private static final String SAR_PLURAL = "subjectaccessreviews";
    private static final String LSAR_PLURAL = "localsubjectaccessreviews";
    private static final String SSAR_PLURAL = "selfsubjectaccessreviews";
    private static final String SSRR_PLURAL = "selfsubjectrulesreviews";
    private boolean isNamespaced = false;

    public SubjectAccessReviewDSLImpl(OperationContext context) {
        super(context.withApiGroupName(AUTHORIZATION).withPlural(SAR_PLURAL));
    }

    private SubjectAccessReviewDSLImpl(OperationContext context, String namespace, String plural, boolean isNamespaced) {
        super(context.withApiGroupName(AUTHORIZATION).withNamespace(namespace).withPlural(plural));
        this.isNamespaced = isNamespaced;
    }

    public SubjectAccessReviewDSLImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.isNamespaced;
    }

    @Override
    public SubjectAccessReview create(SubjectAccessReview ... resources) {
        return new CreatableSubjectAccessReview().create(resources);
    }

    @Override
    public SubjectAccessReview create(SubjectAccessReview resource) {
        return this.create(new SubjectAccessReview[]{resource});
    }

    @Override
    public DoneableSubjectAccessReview createNew() {
        return new CreatableSubjectAccessReview().createNew();
    }

    @Override
    public Createable<LocalSubjectAccessReview, LocalSubjectAccessReview, DoneableLocalSubjectAccessReview> inNamespace(String namespace) {
        return new SubjectAccessReviewDSLImpl(this.context, namespace, LSAR_PLURAL, true).local(namespace);
    }

    @Override
    public Createable<SelfSubjectAccessReview, SelfSubjectAccessReview, DoneableSelfSubjectAccessReview> inAnyNamespace() {
        return new SubjectAccessReviewDSLImpl(this.context, this.namespace, SSAR_PLURAL, true).self();
    }

    private Createable<LocalSubjectAccessReview, LocalSubjectAccessReview, DoneableLocalSubjectAccessReview> local(String namespace) {
        return new CreatableLocalSubjectAccessReview(namespace);
    }

    private Createable<SelfSubjectAccessReview, SelfSubjectAccessReview, DoneableSelfSubjectAccessReview> self() {
        return new CreatableSelfSubjectAccessReview();
    }

    @Override
    public Createable<SelfSubjectRulesReview, SelfSubjectRulesReview, DoneableSelfSubjectRulesReview> list() {
        return new CreatableSelfSubjectRulesReview();
    }

    @Override
    public Createable<SelfSubjectRulesReview, SelfSubjectRulesReview, DoneableSelfSubjectRulesReview> list(Integer limitVal, String continueVal) {
        return null;
    }

    private class CreatableSelfSubjectRulesReview
    implements Createable<SelfSubjectRulesReview, SelfSubjectRulesReview, DoneableSelfSubjectRulesReview> {
        private CreatableSelfSubjectRulesReview() {
        }

        @Override
        public SelfSubjectRulesReview create(SelfSubjectRulesReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SelfSubjectRulesReview)SubjectAccessReviewDSLImpl.this.handleCreate(resources[0], SelfSubjectRulesReview.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public SelfSubjectRulesReview create(SelfSubjectRulesReview resource) {
            return this.create(new SelfSubjectRulesReview[]{resource});
        }

        @Override
        public DoneableSelfSubjectRulesReview createNew() {
            return new DoneableSelfSubjectRulesReview(this::create);
        }
    }

    private class CreatableSelfSubjectAccessReview
    implements Createable<SelfSubjectAccessReview, SelfSubjectAccessReview, DoneableSelfSubjectAccessReview> {
        private CreatableSelfSubjectAccessReview() {
        }

        @Override
        public SelfSubjectAccessReview create(SelfSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SelfSubjectAccessReview)SubjectAccessReviewDSLImpl.this.handleCreate(resources[0], SelfSubjectAccessReview.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public SelfSubjectAccessReview create(SelfSubjectAccessReview resource) {
            return this.create(new SelfSubjectAccessReview[]{resource});
        }

        @Override
        public DoneableSelfSubjectAccessReview createNew() {
            return new DoneableSelfSubjectAccessReview(this::create);
        }
    }

    private class CreatableSubjectAccessReview
    implements Createable<SubjectAccessReview, SubjectAccessReview, DoneableSubjectAccessReview> {
        private CreatableSubjectAccessReview() {
        }

        @Override
        public SubjectAccessReview create(SubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReview)SubjectAccessReviewDSLImpl.this.handleCreate(resources[0], SubjectAccessReview.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public SubjectAccessReview create(SubjectAccessReview resource) {
            return this.create(new SubjectAccessReview[]{resource});
        }

        @Override
        public DoneableSubjectAccessReview createNew() {
            return new DoneableSubjectAccessReview(this::create);
        }
    }

    private class CreatableLocalSubjectAccessReview
    implements Createable<LocalSubjectAccessReview, LocalSubjectAccessReview, DoneableLocalSubjectAccessReview> {
        private final String namespace;

        CreatableLocalSubjectAccessReview(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public LocalSubjectAccessReview create(LocalSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    this.setNamespace(resources[0]);
                    return (LocalSubjectAccessReview)SubjectAccessReviewDSLImpl.this.handleCreate(resources[0], LocalSubjectAccessReview.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public LocalSubjectAccessReview create(LocalSubjectAccessReview resource) {
            return this.create(new LocalSubjectAccessReview[]{resource});
        }

        private void setNamespace(LocalSubjectAccessReview resource) {
            SubjectAccessReviewSpec spec;
            ObjectMeta meta = resource.getMetadata();
            if (meta == null) {
                meta = new ObjectMeta();
                resource.setMetadata(meta);
            }
            if (Utils.isNullOrEmpty(meta.getNamespace())) {
                meta.setNamespace(this.namespace);
            }
            if ((spec = resource.getSpec()) != null && spec.getResourceAttributes() != null && Utils.isNullOrEmpty(spec.getResourceAttributes().getNamespace())) {
                spec.getResourceAttributes().setNamespace(this.namespace);
            }
        }

        @Override
        public DoneableLocalSubjectAccessReview createNew() {
            return new DoneableLocalSubjectAccessReview(this::create);
        }
    }
}

