/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_9.Container;
import io.fabric8.kubernetes.api.model.v4_9.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v4_9.DoneablePod;
import io.fabric8.kubernetes.api.model.v4_9.OwnerReference;
import io.fabric8.kubernetes.api.model.v4_9.Pod;
import io.fabric8.kubernetes.api.model.v4_9.PodList;
import io.fabric8.kubernetes.api.model.v4_9.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_9.Status;
import io.fabric8.kubernetes.api.model.v4_9.apps.DoneableStatefulSet;
import io.fabric8.kubernetes.api.model.v4_9.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v4_9.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.v4_9.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.v4_9.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.v4_9.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.api.model.v4_9.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v4_9.Config;
import io.fabric8.kubernetes.clnt.v4_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_9.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v4_9.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_9.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_9.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.RollingUpdater;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.StatefulSetRollingUpdater;
import io.fabric8.kubernetes.clnt.v4_9.utils.KubernetesResourceUtil;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class StatefulSetOperationsImpl
extends RollableScalableResourceOperation<StatefulSet, StatefulSetList, DoneableStatefulSet, RollableScalableResource<StatefulSet, DoneableStatefulSet>>
implements TimeoutImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> {
    public StatefulSetOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public StatefulSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withCascading(true));
    }

    public StatefulSetOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("statefulsets"));
        this.type = StatefulSet.class;
        this.listType = StatefulSetList.class;
        this.doneableType = DoneableStatefulSet.class;
    }

    public StatefulSetOperationsImpl newInstance(OperationContext context) {
        return new StatefulSetOperationsImpl((RollingOperationContext)context);
    }

    @Override
    StatefulSet withReplicas(int count) {
        return ((DoneableStatefulSet)((StatefulSetFluent.SpecNested)((DoneableStatefulSet)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    RollingUpdater<StatefulSet, StatefulSetList, DoneableStatefulSet> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new StatefulSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    int getCurrentReplicas(StatefulSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(StatefulSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(StatefulSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public StatefulSetOperationsImpl rolling() {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public StatefulSet updateImage(String image) {
        StatefulSet oldRC = (StatefulSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing StatefulSet doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        StatefulSetBuilder newRCBuilder = new StatefulSetBuilder(oldRC);
        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new StatefulSetRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> withTimeout(long timeout, TimeUnit unit) {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(unit.toMillis(timeout)).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> withTimeoutInMillis(long timeoutInMillis) {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of StatefulSets");
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod, DoneablePod>> podOperationList = this.doGetLog(isPretty);
        for (PodResource<Pod, DoneablePod> podOperation : podOperationList) {
            stringBuilder.append((String)podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod, DoneablePod>> doGetLog(boolean isPretty) {
        ArrayList<PodResource<Pod, DoneablePod>> pods = new ArrayList<PodResource<Pod, DoneablePod>>();
        StatefulSet statefulSet = (StatefulSet)this.fromServer().get();
        String rcUid = statefulSet.getMetadata().getUid();
        PodOperationsImpl podOperations = new PodOperationsImpl(new PodOperationContext(this.context.getClient(), this.context.getConfig(), this.context.getPlural(), this.context.getNamespace(), this.context.getName(), null, "v1", this.context.getCascading(), this.context.getItem(), this.context.getLabels(), this.context.getLabelsNot(), this.context.getLabelsIn(), this.context.getLabelsNotIn(), this.context.getFields(), this.context.getFieldsNot(), this.context.getResourceVersion(), this.context.getReloadingFromServer(), this.context.getGracePeriodSeconds(), this.context.getPropagationPolicy(), null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, isPretty, null, null, null, null, null));
        PodList jobPodList = (PodList)podOperations.withLabels((Map)statefulSet.getSpec().getTemplate().getMetadata().getLabels()).list();
        for (Pod pod : jobPodList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(pod);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            pods.add((PodResource<Pod, DoneablePod>)podOperations.withName(pod.getMetadata().getName()));
        }
        return pods;
    }

    @Override
    public Reader getLogReader() {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }
}

