/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9.dsl.base;

import io.fabric8.kubernetes.api.builder.v4_9.Function;
import io.fabric8.kubernetes.api.model.v4_9.Doneable;
import io.fabric8.kubernetes.api.model.v4_9.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_9.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_9.LabelSelector;
import io.fabric8.kubernetes.api.model.v4_9.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v4_9.RootPaths;
import io.fabric8.kubernetes.api.model.v4_9.Status;
import io.fabric8.kubernetes.api.model.v4_9.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.v4_9.v1.Scale;
import io.fabric8.kubernetes.clnt.v4_9.Config;
import io.fabric8.kubernetes.clnt.v4_9.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v4_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_9.OperationInfo;
import io.fabric8.kubernetes.clnt.v4_9.ResourceNotFoundException;
import io.fabric8.kubernetes.clnt.v4_9.Watch;
import io.fabric8.kubernetes.clnt.v4_9.Watcher;
import io.fabric8.kubernetes.clnt.v4_9.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_9.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_9.dsl.Replaceable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_9.dsl.Watchable;
import io.fabric8.kubernetes.clnt.v4_9.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_9.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.DefaultOperationInfo;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.clnt.v4_9.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.clnt.v4_9.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v4_9.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v4_9.utils.Utils;
import io.fabric8.kubernetes.clnt.v4_9.utils.WatcherToggle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.HttpUrl;
import okhttp3.Request;

public class BaseOperation<T, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends OperationSupport
implements OperationInfo,
MixedOperation<T, L, D, R>,
Resource<T, D> {
    private final Boolean cascading;
    private final T item;
    private final Map<String, String> labels;
    private final Map<String, String[]> labelsNot;
    private final Map<String, String[]> labelsIn;
    private final Map<String, String[]> labelsNotIn;
    private final Map<String, String> fields;
    private final Map<String, String[]> fieldsNot;
    private final String resourceVersion;
    private final Boolean reloadingFromServer;
    private final long gracePeriodSeconds;
    private final String propagationPolicy;
    protected String apiVersion;
    protected Class<T> type;
    protected Class<L> listType;
    protected Class<D> doneableType;

    protected BaseOperation(OperationContext ctx) {
        super(ctx);
        this.cascading = ctx.getCascading();
        this.item = ctx.getItem();
        this.reloadingFromServer = ctx.getReloadingFromServer();
        this.resourceVersion = ctx.getResourceVersion();
        this.gracePeriodSeconds = ctx.getGracePeriodSeconds();
        this.propagationPolicy = ctx.getPropagationPolicy();
        this.labels = ctx.getLabels();
        this.labelsNot = ctx.getLabelsNot();
        this.labelsIn = ctx.getLabelsIn();
        this.labelsNotIn = ctx.getLabelsNotIn();
        this.fields = ctx.getFields();
        this.fieldsNot = ctx.getFieldsNot();
    }

    private static <T> String name(T item, String name) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        if (item instanceof HasMetadata) {
            HasMetadata h = (HasMetadata)item;
            return h.getMetadata() != null ? h.getMetadata().getName() : null;
        }
        return null;
    }

    public BaseOperation<T, L, D, R> newInstance(OperationContext context) {
        return new BaseOperation<T, L, D, R>(context);
    }

    private L listRequestHelper(URL url) {
        try {
            HttpUrl.Builder requestUrlBuilder = HttpUrl.get((URL)url).newBuilder();
            this.addQueryStringParam(requestUrlBuilder, "labelSelector", this.getLabelQueryParam());
            this.addQueryStringParam(requestUrlBuilder, "fieldSelector", this.getFieldQueryParam());
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrlBuilder.build());
            KubernetesResourceList answer = (KubernetesResourceList)this.handleResponse(requestBuilder, this.listType);
            this.updateApiVersion(answer);
            return (L)answer;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    private void addQueryStringParam(HttpUrl.Builder requestUrlBuilder, String name, String value) {
        if (Utils.isNotNullOrEmpty(value)) {
            requestUrlBuilder.addQueryParameter(name, value);
        }
    }

    @Override
    public T get() {
        try {
            T answer = this.getMandatory();
            if (answer instanceof HasMetadata) {
                HasMetadata hasMetadata = (HasMetadata)answer;
                this.updateApiVersion(hasMetadata);
            } else if (answer instanceof KubernetesResourceList) {
                KubernetesResourceList list = (KubernetesResourceList)answer;
                this.updateApiVersion(list);
            }
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public T require() throws ResourceNotFoundException {
        try {
            T answer = this.getMandatory();
            if (answer == null) {
                throw new ResourceNotFoundException("The resource you request doesn't exist or couldn't be fetched.");
            }
            if (answer instanceof HasMetadata) {
                HasMetadata hasMetadata = (HasMetadata)answer;
                this.updateApiVersion(hasMetadata);
            } else if (answer instanceof KubernetesResourceList) {
                KubernetesResourceList list = (KubernetesResourceList)answer;
                this.updateApiVersion(list);
            }
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            throw new ResourceNotFoundException("Resource not found : " + e.getMessage());
        }
    }

    public T getMandatory() {
        if (this.item != null && !this.reloadingFromServer.booleanValue()) {
            return this.item;
        }
        try {
            URL requestUrl = this.getCompleteResourceUrl();
            return this.handleGet(requestUrl);
        }
        catch (KubernetesClientException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)e);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)e);
        }
    }

    public RootPaths getRootPaths() {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            Request.Builder req = new Request.Builder().get().url(requestUrl);
            return this.handleResponse(req, RootPaths.class);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D edit() throws KubernetesClientException {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    @Override
    public R withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return (R)this.newInstance(this.context.withName(name));
    }

    @Override
    public Replaceable<T, T> lockResourceVersion(String resourceVersion) {
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public NonNamespaceOperation<T, L, D, R> inNamespace(String namespace) {
        return this.newInstance(this.context.withNamespace(namespace));
    }

    @Override
    public NonNamespaceOperation<T, L, D, R> inAnyNamespace() {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.config).withNamespace(null)).build();
        return this.newInstance(this.context.withConfig(updated).withNamespace(null));
    }

    @Override
    public EditReplacePatchDeletable<T, T, D, Boolean> cascading(boolean cascading) {
        return this.newInstance(this.context.withCascading(cascading));
    }

    @Override
    public R load(InputStream is) {
        return (R)this.newInstance(this.context.withItem(BaseOperation.unmarshal(is, this.type)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(URL url) {
        try (InputStream inputStream = url.openStream();){
            Object object = this.load(inputStream);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Object object = this.load(fis);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public R load(String path) {
        return (R)this.load(new File(path));
    }

    @Override
    public Gettable<T> fromServer() {
        return this.newInstance(this.context.withReloadingFromServer(true));
    }

    @Override
    public T create(T ... resources) throws KubernetesClientException {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return (T)this.withItem(resources[0]).create(new Object[0]);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.getItem());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
        }
    }

    @Override
    public T create(T resource) {
        try {
            if (resource != null) {
                return this.handleCreate(resource);
            }
            throw new IllegalArgumentException("Nothing to create.");
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
        }
    }

    @Override
    public D createNew() throws KubernetesClientException {
        Function<Object, Object> visitor = resource -> {
            try {
                return this.create((T)resource);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(Function.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
        }
    }

    @Override
    public D createOrReplaceWithNew() throws KubernetesClientException {
        Function<Object, Object> visitor = resource -> {
            try {
                return this.createOrReplace((T[])new Object[]{resource});
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType("create or replace"), (Throwable)e);
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(Function.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create or replace"), (Throwable)e);
        }
    }

    @Override
    public T createOrReplace(T ... items) {
        T item = this.getItem();
        if (items.length > 1) {
            throw new IllegalArgumentException("Too many items to create.");
        }
        if (items.length == 1) {
            item = items[0];
        }
        if (item == null) {
            throw new IllegalArgumentException("Nothing to create.");
        }
        if (Utils.isNullOrEmpty(this.name) && item instanceof HasMetadata) {
            return this.withName(((HasMetadata)item).getMetadata().getName()).createOrReplace(item);
        }
        if (this.fromServer().get() == null) {
            return this.create(item);
        }
        return this.replace(item);
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withLabelSelector(LabelSelector selector) {
        List<LabelSelectorRequirement> matchExpressions;
        Map<String, String> matchLabels = selector.getMatchLabels();
        if (matchLabels != null) {
            this.labels.putAll(matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block12: for (LabelSelectorRequirement req : matchExpressions) {
                String operator = req.getOperator();
                String key = req.getKey();
                switch (operator) {
                    case "In": {
                        this.withLabelIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "NotIn": {
                        this.withLabelNotIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "DoesNotExist": {
                        this.withoutLabel(key);
                        continue block12;
                    }
                    case "Exists": {
                        this.withLabel(key);
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unsupported operator: " + operator);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withoutLabels(Map<String, String> labels) throws KubernetesClientException {
        labels.forEach((string, string2) -> this.withoutLabel((String)string, (String)string2));
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withLabelIn(String key, String ... values) throws KubernetesClientException {
        this.labelsIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withLabelNotIn(String key, String ... values) throws KubernetesClientException {
        this.labelsNotIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withLabel(String key) {
        return this.withLabel(key, null);
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withoutLabel(String key, String value) {
        this.labelsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
            System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
            System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
            return concatList;
        });
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withoutLabel(String key) {
        return this.withoutLabel(key, null);
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withFields(Map<String, String> fields) {
        this.fields.putAll(fields);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withField(String key, String value) {
        this.fields.put(key, value);
        return this;
    }

    @Override
    @Deprecated
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withoutFields(Map<String, String> fields) throws KubernetesClientException {
        this.labels.forEach((string, string2) -> this.withoutField((String)string, (String)string2));
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withoutField(String key, String value) {
        this.fieldsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            if (Utils.isNotNullOrEmpty(newList[0])) {
                String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
                System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
                System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
                return concatList;
            }
            return oldList;
        });
        return this;
    }

    public String getLabelQueryParam() {
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> iter;
        StringBuilder sb = new StringBuilder();
        if (this.labels != null && !this.labels.isEmpty()) {
            iter = this.labels.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((entry = iter.next()).getValue() != null) {
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    continue;
                }
                sb.append(entry.getKey());
            }
        }
        if (this.labelsNot != null && !this.labelsNot.isEmpty()) {
            iter = this.labelsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (Utils.isNotNull((Object[])(entry = iter.next()).getValue())) {
                    for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(entry.getKey()).append("!=").append(((String[])entry.getValue())[i]);
                    }
                    continue;
                }
                sb.append('!').append(entry.getKey());
            }
        }
        if (this.labelsIn != null && !this.labelsIn.isEmpty()) {
            iter = this.labelsIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" in ").append("(").append(Utils.join((Object[])entry.getValue())).append(")");
            }
        }
        if (this.labelsNotIn != null && !this.labelsNotIn.isEmpty()) {
            iter = this.labelsNotIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" notin ").append("(").append(Utils.join((Object[])entry.getValue())).append(")");
            }
        }
        return sb.toString();
    }

    public String getFieldQueryParam() {
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> iter;
        StringBuilder sb = new StringBuilder();
        if (this.fields != null && !this.fields.isEmpty()) {
            iter = this.fields.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        if (this.fieldsNot != null && !this.fieldsNot.isEmpty()) {
            iter = this.fieldsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(entry.getKey()).append("!=").append(((String[])entry.getValue())[i]);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public L list() throws KubernetesClientException {
        try {
            return this.listRequestHelper(this.getNamespacedUrl());
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    @Override
    public L list(Integer limitVal, String continueVal) throws KubernetesClientException {
        try {
            URL url = this.getNamespacedUrl();
            if (limitVal != null && continueVal == null) {
                url = new URL(URLUtils.join(url.toString(), "?limit=" + limitVal.toString()));
            } else if (continueVal != null) {
                url = new URL(URLUtils.join(url.toString(), "?continue=" + continueVal + "&limit=" + limitVal.toString()));
            }
            return this.listRequestHelper(url);
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    @Override
    public Boolean delete() {
        if (this.item != null || this.name != null && !this.name.isEmpty()) {
            try {
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    @Override
    public Boolean delete(T ... items) {
        return this.delete((List)Arrays.asList(items));
    }

    @Override
    public Boolean delete(List<T> items) {
        boolean deleted = true;
        if (items != null) {
            for (T item : items) {
                this.updateApiVersionResource(item);
                try {
                    Resource<T, D> op = item instanceof HasMetadata && ((HasMetadata)item).getMetadata() != null && ((HasMetadata)item).getMetadata().getName() != null && !((HasMetadata)item).getMetadata().getName().isEmpty() ? (Resource)this.inNamespace(this.checkNamespace(item)).withName(((HasMetadata)item).getMetadata().getName()) : this.withItem(item);
                    deleted &= ((Boolean)op.delete()).booleanValue();
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 404) {
                        throw e;
                    }
                    return false;
                }
            }
        }
        return deleted;
    }

    @Override
    public T updateStatus(T item) throws KubernetesClientException {
        try {
            return this.handleStatusUpdate(item, this.getType());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("statusUpdate"), (Throwable)e);
        }
    }

    public BaseOperation<T, L, D, R> withItem(T item) {
        return this.newInstance(this.context.withItem(item));
    }

    void deleteThis() throws KubernetesClientException {
        try {
            if (this.item != null) {
                this.updateApiVersionResource(this.item);
                this.handleDelete(this.item, this.gracePeriodSeconds, this.propagationPolicy, (boolean)this.cascading);
            } else {
                this.handleDelete(this.getResourceUrl(), this.gracePeriodSeconds, this.propagationPolicy, (boolean)this.cascading);
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("delete"), (Throwable)e);
        }
    }

    void deleteList() throws KubernetesClientException {
        this.delete(this.list().getItems());
    }

    @Override
    public Watchable<Watch, Watcher<T>> withResourceVersion(String resourceVersion) {
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public Watch watch(Watcher<T> watcher) throws KubernetesClientException {
        return this.watch(this.resourceVersion, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<T> watcher) throws KubernetesClientException {
        WatcherToggle<T> watcherToggle = new WatcherToggle<T>(watcher, true);
        WatchConnectionManager watch = null;
        try {
            watch = new WatchConnectionManager(this.client, this, resourceVersion, watcherToggle, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getWebsocketTimeout());
            watch.waitUntilReady();
            return watch;
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watch"), (Throwable)e);
        }
        catch (KubernetesClientException ke) {
            if (ke.getCode() != 200) {
                if (watch != null) {
                    watch.close();
                }
                throw ke;
            }
            if (watch != null) {
                watcherToggle.disable();
                watch.close();
            }
            try {
                return new WatchHTTPManager(this.client, this, resourceVersion, watcher, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getConnectionTimeout());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType("watch"), (Throwable)e);
            }
        }
    }

    @Override
    public T replace(T item) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    @Override
    public T patch(T item) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    @Override
    public boolean isResourceNamespaced() {
        return true;
    }

    protected T handleResponse(Request.Builder requestBuilder) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleResponse(requestBuilder, this.getType());
    }

    protected T handleCreate(T resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        this.updateApiVersionResource(resource);
        return this.handleCreate(resource, this.getType());
    }

    protected T handleReplace(T updated) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        this.updateApiVersionResource(updated);
        return this.handleReplace(updated, this.getType());
    }

    protected T handlePatch(T current, T updated) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        this.updateApiVersionResource(updated);
        return this.handlePatch(current, updated, this.getType());
    }

    protected Scale handleScale(Scale scaleParam) {
        try {
            return this.handleScale(this.getCompleteResourceUrl().toString(), scaleParam);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("scale"), (Throwable)e);
        }
    }

    protected Status handleDeploymentRollback(DeploymentRollback deploymentRollback) {
        try {
            return this.handleDeploymentRollback(this.getCompleteResourceUrl().toString(), deploymentRollback);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("rollback"), (Throwable)e);
        }
    }

    protected T handleGet(URL resourceUrl) throws InterruptedException, ExecutionException, IOException {
        T answer = this.handleGet(resourceUrl, this.getType());
        this.updateApiVersionResource(answer);
        return answer;
    }

    private URL getCompleteResourceUrl() throws MalformedURLException {
        URL requestUrl = null;
        requestUrl = this.item != null ? this.getNamespacedUrl(this.item) : this.getNamespacedUrl();
        if (this.name != null) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.name));
        } else if (this.item != null && this.reloadingFromServer.booleanValue()) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.checkName(this.item)));
        }
        return requestUrl;
    }

    public Boolean isCascading() {
        return this.cascading;
    }

    public T getItem() {
        return this.item;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Deprecated
    public Boolean getReloadingFromServer() {
        return this.isReloadingFromServer();
    }

    public Boolean isReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    @Override
    public String getResourceT() {
        return this.resourceT;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    public Class<D> getDoneableType() {
        return this.doneableType;
    }

    protected Map<String, String> getLabels() {
        return this.labels;
    }

    protected Map<String, String[]> getLabelsNot() {
        return this.labelsNot;
    }

    protected Map<String, String[]> getLabelsIn() {
        return this.labelsIn;
    }

    protected Map<String, String[]> getLabelsNotIn() {
        return this.labelsNotIn;
    }

    protected Map<String, String> getFields() {
        return this.fields;
    }

    protected Map<String, String[]> getFieldsNot() {
        return this.fieldsNot;
    }

    @Override
    public String getKind() {
        return this.type != null ? this.type.getSimpleName() : "Resource";
    }

    @Override
    public String getOperationType() {
        return null;
    }

    @Override
    public OperationInfo forOperationType(String type) {
        return new DefaultOperationInfo(this.getKind(), type, this.name, this.namespace);
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds));
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean, Watch, Watcher<T>> withPropagationPolicy(String propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy));
    }

    protected Class<? extends Config> getConfigType() {
        return Config.class;
    }

    protected void updateApiVersionResource(Object resource) {
        if (resource instanceof HasMetadata) {
            HasMetadata hasMetadata = (HasMetadata)resource;
            this.updateApiVersion(hasMetadata);
        } else if (resource instanceof KubernetesResourceList) {
            KubernetesResourceList list = (KubernetesResourceList)resource;
            this.updateApiVersion(list);
        }
    }

    protected void updateApiVersion(KubernetesResourceList list) {
        List items;
        String version = this.getApiVersion();
        if (list != null && version != null && version.length() > 0 && (items = list.getItems()) != null) {
            for (Object item : items) {
                if (!(item instanceof HasMetadata)) continue;
                this.updateApiVersion((HasMetadata)item);
            }
        }
    }

    protected void updateApiVersion(HasMetadata hasMetadata) {
        String current;
        String version = this.getApiVersion();
        if (hasMetadata != null && version != null && version.length() > 0 && ((current = hasMetadata.getApiVersion()) == null || "v1".equals(current) || current.indexOf(47) < 0 && version.indexOf(47) > 0)) {
            hasMetadata.setApiVersion(version);
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean isApiGroup() {
        return this.apiVersion != null && this.apiVersion.indexOf(47) > 0;
    }

    @Override
    public Boolean isReady() {
        T i = this.get();
        return i instanceof HasMetadata && Readiness.isReady((HasMetadata)i);
    }

    protected T waitUntilExists(long amount, TimeUnit timeUnit) throws InterruptedException {
        return (T)this.waitUntilCondition(Objects::nonNull, amount, timeUnit);
    }

    @Override
    public T waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        Object item;
        long timeoutInNanos = timeUnit.toNanos(amount);
        long end = System.nanoTime() + timeoutInNanos;
        while (System.nanoTime() < end) {
            item = this.fromServer().get();
            if (Readiness.isReady((HasMetadata)item)) {
                return item;
            }
            Thread.sleep(500L);
        }
        item = this.fromServer().get();
        if (Readiness.isReady((HasMetadata)item)) {
            return item;
        }
        throw new IllegalStateException(this.type.getSimpleName() + " with name:[" + this.name + "] in namespace:[" + this.namespace + "] not ready!");
    }

    @Override
    public T waitUntilCondition(Predicate<T> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        T item;
        long timeoutInMillis = timeUnit.toNanos(amount);
        long end = System.nanoTime() + timeoutInMillis;
        while (System.nanoTime() < end) {
            item = this.get();
            if (condition.test(item)) {
                return item;
            }
            Thread.sleep(500L);
        }
        item = this.get();
        if (condition.test(item)) {
            return item;
        }
        throw new IllegalArgumentException(this.type.getSimpleName() + " with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void setListType(Class<L> listType) {
        this.listType = listType;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

