/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9;

import io.fabric8.kubernetes.api.builder.v4_9.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_9.HasMetadata;
import io.fabric8.kubernetes.clnt.v4_9.ResourceHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class Handlers {
    private static final Set<ClassLoader> CLASS_LOADERS = new HashSet<ClassLoader>();
    private static final Map<ResourceHandler.Key, ResourceHandler> RESOURCE_HANDLER_MAP = new HashMap<ResourceHandler.Key, ResourceHandler>();

    private Handlers() {
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> void register(ResourceHandler<T, V> handler) {
        RESOURCE_HANDLER_MAP.put(new ResourceHandler.Key(handler.getKind().toLowerCase(Locale.ROOT), handler.getApiVersion()), handler);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> void unregister(ResourceHandler<T, V> handler) {
        RESOURCE_HANDLER_MAP.remove(new ResourceHandler.Key(handler.getKind().toLowerCase(Locale.ROOT), handler.getApiVersion()));
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(String kind, String apiVersion) {
        return Handlers.get(kind, apiVersion, Thread.currentThread().getContextClassLoader());
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(String kind, String apiVersion, ClassLoader classLoader) {
        return Handlers.get(new ResourceHandler.Key(kind.toLowerCase(Locale.ROOT), apiVersion), classLoader);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(ResourceHandler.Key key) {
        return Handlers.get(key, Thread.currentThread().getContextClassLoader());
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(ResourceHandler.Key key, ClassLoader classLoader) {
        if (RESOURCE_HANDLER_MAP.containsKey(key)) {
            return RESOURCE_HANDLER_MAP.get(key);
        }
        for (ResourceHandler handler : ServiceLoader.load(ResourceHandler.class, classLoader)) {
            if (!handler.getKind().toLowerCase(Locale.ROOT).equals(key.getKind()) || !handler.getApiVersion().equals(key.getApiVersion())) continue;
            return handler;
        }
        for (ResourceHandler handler : ServiceLoader.load(ResourceHandler.class, classLoader)) {
            if (!handler.getKind().toLowerCase(Locale.ROOT).equals(key.getKind())) continue;
            return handler;
        }
        return null;
    }

    private static void discoverHandlers(ClassLoader classLoader) {
        if (classLoader != null && CLASS_LOADERS.add(classLoader)) {
            for (ResourceHandler handler : ServiceLoader.load(ResourceHandler.class, classLoader)) {
                Handlers.register(handler);
            }
        }
    }

    static {
        Handlers.discoverHandlers(ResourceHandler.class.getClassLoader());
    }
}

