/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_9.apps;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Nested;
import io.fabric8.kubernetes.api.model.v4_9.LabelSelector;
import io.fabric8.kubernetes.api.model.v4_9.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v4_9.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v4_9.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v4_9.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v4_9.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v4_9.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.v4_9.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.v4_9.apps.DeploymentStrategy;
import io.fabric8.kubernetes.api.model.v4_9.apps.DeploymentStrategyBuilder;
import io.fabric8.kubernetes.api.model.v4_9.apps.DeploymentStrategyFluentImpl;

public class DeploymentSpecFluentImpl<A extends DeploymentSpecFluent<A>>
extends BaseFluent<A>
implements DeploymentSpecFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer progressDeadlineSeconds;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private LabelSelectorBuilder selector;
    private DeploymentStrategyBuilder strategy;
    private PodTemplateSpecBuilder template;

    public DeploymentSpecFluentImpl() {
    }

    public DeploymentSpecFluentImpl(DeploymentSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Boolean isPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Boolean hasPaused() {
        return this.paused != null;
    }

    @Override
    public A withNewPaused(String arg1) {
        return this.withPaused(new Boolean(arg1));
    }

    @Override
    public A withNewPaused(boolean arg1) {
        return this.withPaused(new Boolean(arg1));
    }

    @Override
    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    @Override
    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public DeploymentStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public A withStrategy(DeploymentStrategy strategy) {
        this._visitables.get("strategy").remove(this.strategy);
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.get("strategy").add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : new DeploymentStrategyBuilder().build());
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : item);
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentSpecFluentImpl that = (DeploymentSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.paused != null ? !this.paused.equals(that.paused) : that.paused != null) {
            return false;
        }
        if (this.progressDeadlineSeconds != null ? !this.progressDeadlineSeconds.equals(that.progressDeadlineSeconds) : that.progressDeadlineSeconds != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DeploymentSpecFluent.TemplateNested<N>>
    implements DeploymentSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class StrategyNestedImpl<N>
    extends DeploymentStrategyFluentImpl<DeploymentSpecFluent.StrategyNested<N>>
    implements DeploymentSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final DeploymentStrategyBuilder builder;

        StrategyNestedImpl(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        StrategyNestedImpl() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withStrategy(this.builder.build());
        }

        @Override
        public N endStrategy() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<DeploymentSpecFluent.SelectorNested<N>>
    implements DeploymentSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

