/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_9;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Predicate;
import io.fabric8.kubernetes.api.model.v4_9.PatchOptions;
import io.fabric8.kubernetes.api.model.v4_9.PatchOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PatchOptionsFluentImpl<A extends PatchOptionsFluent<A>>
extends BaseFluent<A>
implements PatchOptionsFluent<A> {
    private String apiVersion;
    private List<String> dryRun = new ArrayList<String>();
    private String fieldManager;
    private Boolean force;
    private String kind;

    public PatchOptionsFluentImpl() {
    }

    public PatchOptionsFluentImpl(PatchOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDryRun(instance.getDryRun());
        this.withFieldManager(instance.getFieldManager());
        this.withForce(instance.getForce());
        this.withKind(instance.getKind());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDryRun(String ... items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDryRun(Collection<String> items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDryRun() {
        return this.dryRun;
    }

    @Override
    public String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    @Override
    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    @Override
    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    @Override
    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDryRun(List<String> dryRun) {
        if (this.dryRun != null) {
            this._visitables.get("dryRun").removeAll(this.dryRun);
        }
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)this;
    }

    @Override
    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    @Override
    public A addNewDryRun(String arg1) {
        return this.addToDryRun(new String(arg1));
    }

    @Override
    public A addNewDryRun(StringBuilder arg1) {
        return this.addToDryRun(new String(arg1));
    }

    @Override
    public A addNewDryRun(StringBuffer arg1) {
        return this.addToDryRun(new String(arg1));
    }

    @Override
    public String getFieldManager() {
        return this.fieldManager;
    }

    @Override
    public A withFieldManager(String fieldManager) {
        this.fieldManager = fieldManager;
        return (A)this;
    }

    @Override
    public Boolean hasFieldManager() {
        return this.fieldManager != null;
    }

    @Override
    public A withNewFieldManager(String arg1) {
        return this.withFieldManager(new String(arg1));
    }

    @Override
    public A withNewFieldManager(StringBuilder arg1) {
        return this.withFieldManager(new String(arg1));
    }

    @Override
    public A withNewFieldManager(StringBuffer arg1) {
        return this.withFieldManager(new String(arg1));
    }

    @Override
    public Boolean isForce() {
        return this.force;
    }

    @Override
    public A withForce(Boolean force) {
        this.force = force;
        return (A)this;
    }

    @Override
    public Boolean hasForce() {
        return this.force != null;
    }

    @Override
    public A withNewForce(String arg1) {
        return this.withForce(new Boolean(arg1));
    }

    @Override
    public A withNewForce(boolean arg1) {
        return this.withForce(new Boolean(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchOptionsFluentImpl that = (PatchOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dryRun != null ? !this.dryRun.equals(that.dryRun) : that.dryRun != null) {
            return false;
        }
        if (this.fieldManager != null ? !this.fieldManager.equals(that.fieldManager) : that.fieldManager != null) {
            return false;
        }
        if (this.force != null ? !this.force.equals(that.force) : that.force != null) {
            return false;
        }
        return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
    }
}

