/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_9;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Nested;
import io.fabric8.kubernetes.api.builder.v4_9.Predicate;
import io.fabric8.kubernetes.api.model.v4_9.Cluster;
import io.fabric8.kubernetes.api.model.v4_9.ClusterFluent;
import io.fabric8.kubernetes.api.model.v4_9.NamedExtension;
import io.fabric8.kubernetes.api.model.v4_9.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.v4_9.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ClusterFluentImpl<A extends ClusterFluent<A>>
extends BaseFluent<A>
implements ClusterFluent<A> {
    private String certificateAuthority;
    private String certificateAuthorityData;
    private List<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
    private Boolean insecureSkipTlsVerify;
    private String server;

    public ClusterFluentImpl() {
    }

    public ClusterFluentImpl(Cluster instance) {
        this.withCertificateAuthority(instance.getCertificateAuthority());
        this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        this.withExtensions(instance.getExtensions());
        this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        this.withServer(instance.getServer());
    }

    @Override
    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    @Override
    public A withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return (A)this;
    }

    @Override
    public Boolean hasCertificateAuthority() {
        return this.certificateAuthority != null;
    }

    @Override
    public A withNewCertificateAuthority(String arg1) {
        return this.withCertificateAuthority(new String(arg1));
    }

    @Override
    public A withNewCertificateAuthority(StringBuilder arg1) {
        return this.withCertificateAuthority(new String(arg1));
    }

    @Override
    public A withNewCertificateAuthority(StringBuffer arg1) {
        return this.withCertificateAuthority(new String(arg1));
    }

    @Override
    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    @Override
    public A withCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
        return (A)this;
    }

    @Override
    public Boolean hasCertificateAuthorityData() {
        return this.certificateAuthorityData != null;
    }

    @Override
    public A withNewCertificateAuthorityData(String arg1) {
        return this.withCertificateAuthorityData(new String(arg1));
    }

    @Override
    public A withNewCertificateAuthorityData(StringBuilder arg1) {
        return this.withCertificateAuthorityData(new String(arg1));
    }

    @Override
    public A withNewCertificateAuthorityData(StringBuffer arg1) {
        return this.withCertificateAuthorityData(new String(arg1));
    }

    @Override
    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        this._visitables.get("extensions").add(index >= 0 ? index : this._visitables.get("extensions").size(), builder);
        this.extensions.add(index >= 0 ? index : this.extensions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this._visitables.get("extensions").size()) {
            this._visitables.get("extensions").add(builder);
        } else {
            this._visitables.get("extensions").set(index, builder);
        }
        if (index < 0 || index >= this.extensions.size()) {
            this.extensions.add(builder);
        } else {
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)this;
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        Object visitables = this._visitables.get("extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedExtension> getExtensions() {
        return ClusterFluentImpl.build(this.extensions);
    }

    @Override
    public List<NamedExtension> buildExtensions() {
        return ClusterFluentImpl.build(this.extensions);
    }

    @Override
    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    @Override
    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    @Override
    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    @Override
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get("extensions").removeAll(this.extensions);
        }
        if (extensions != null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(-1, item);
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNestedImpl(index, item);
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.apply(this.extensions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public Boolean isInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    @Override
    public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        return (A)this;
    }

    @Override
    public Boolean hasInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify != null;
    }

    @Override
    public A withNewInsecureSkipTlsVerify(String arg1) {
        return this.withInsecureSkipTlsVerify(new Boolean(arg1));
    }

    @Override
    public A withNewInsecureSkipTlsVerify(boolean arg1) {
        return this.withInsecureSkipTlsVerify(new Boolean(arg1));
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    @Override
    public Boolean hasServer() {
        return this.server != null;
    }

    @Override
    public A withNewServer(String arg1) {
        return this.withServer(new String(arg1));
    }

    @Override
    public A withNewServer(StringBuilder arg1) {
        return this.withServer(new String(arg1));
    }

    @Override
    public A withNewServer(StringBuffer arg1) {
        return this.withServer(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterFluentImpl that = (ClusterFluentImpl)o;
        if (this.certificateAuthority != null ? !this.certificateAuthority.equals(that.certificateAuthority) : that.certificateAuthority != null) {
            return false;
        }
        if (this.certificateAuthorityData != null ? !this.certificateAuthorityData.equals(that.certificateAuthorityData) : that.certificateAuthorityData != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.insecureSkipTlsVerify != null ? !this.insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) : that.insecureSkipTlsVerify != null) {
            return false;
        }
        return !(this.server != null ? !this.server.equals(that.server) : that.server != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ClusterFluent.ExtensionsNested<N>>
    implements ClusterFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;
        private final int index;

        ExtensionsNestedImpl(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.index = -1;
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterFluentImpl.this.setToExtensions(this.index, this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

