/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.SelfSubjectAccessReviewBuilder;
import io.fabric8.kubernetes.api.model.authorization.SelfSubjectRulesReview;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Createable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.client.dsl.CreateableSelfSubjectAccessReview;
import io.fabric8.openshift.client.dsl.CreateableSelfSubjectRulesReview;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import io.fabric8.openshift.client.dsl.SubjectAccessReviewOperation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class SubjectAccessReviewOperationImpl
extends OperationSupport
implements SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview, CreateableSelfSubjectAccessReview, CreateableSelfSubjectRulesReview> {
    public SubjectAccessReviewOperationImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public SubjectAccessReviewOperationImpl(OperationContext context) {
        super(context.withApiGroupName("authorization.openshift.io").withPlural("subjectaccessreviews"));
    }

    @Override
    public CreateableLocalSubjectAccessReview inNamespace(String namespace) {
        return new SubjectAccessReviewOperationImpl(this.client, OpenShiftConfig.wrap(this.getConfig())).local();
    }

    @Override
    public SubjectAccessReviewResponse create(SubjectAccessReview ... item) {
        return new CreateableSubjectAccessReviewImpl(this.client).create(item);
    }

    @Override
    public SubjectAccessReviewResponse create(SubjectAccessReview item) {
        return this.create(new SubjectAccessReview[]{item});
    }

    @Override
    public CreateableSubjectAccessReview createNew() {
        return new CreateableSubjectAccessReviewImpl(this.client).createNew();
    }

    @Override
    public URL getRootUrl() {
        if (Utils.isNullOrEmpty(this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        return super.getRootUrl();
    }

    @Override
    public Createable inAnyNamespace() {
        return new SubjectAccessReviewOperationImpl(this.client, OpenShiftConfig.wrap(this.getConfig())).self();
    }

    private CreateableSelfSubjectAccessReview self() {
        return new CreateableSelfSubjectAccessReviewImpl(this.client);
    }

    @Override
    public Createable<SelfSubjectRulesReview, SelfSubjectRulesReview, CreateableSelfSubjectRulesReview> list() {
        return null;
    }

    @Override
    public Createable<SelfSubjectRulesReview, SelfSubjectRulesReview, CreateableSelfSubjectRulesReview> list(Integer limitVal, String continueVal) {
        return null;
    }

    private CreateableLocalSubjectAccessReview local() {
        return new CreateableLocalSubjectAccessReviewImpl(this.client);
    }

    @Override
    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata && ((HasMetadata)item).getMetadata() != null ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    private class CreateableSelfSubjectAccessReviewImpl
    extends CreateableSelfSubjectAccessReview {
        private final OkHttpClient client;
        private final SelfSubjectAccessReviewBuilder builder;

        private CreateableSelfSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new SelfSubjectAccessReviewBuilder(this);
        }

        private CreateableSelfSubjectAccessReviewImpl(OkHttpClient client, SelfSubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        @Override
        public SubjectAccessReviewResponse create(SelfSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)SubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public SubjectAccessReviewResponse create(SelfSubjectAccessReview resource) {
            return this.create(new SelfSubjectAccessReview[]{resource});
        }

        @Override
        public CreateableSelfSubjectAccessReview createNew() {
            return this;
        }

        @Override
        public SubjectAccessReviewResponse done() {
            return this.create(this.builder.build());
        }
    }

    private class CreateableSubjectAccessReviewImpl
    extends CreateableSubjectAccessReview {
        private final OkHttpClient client;
        private final SubjectAccessReviewBuilder builder;

        private CreateableSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new SubjectAccessReviewBuilder(this);
        }

        private CreateableSubjectAccessReviewImpl(OkHttpClient client, SubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        @Override
        public SubjectAccessReviewResponse create(SubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)SubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public SubjectAccessReviewResponse create(SubjectAccessReview resource) {
            return this.create(new SubjectAccessReview[]{resource});
        }

        @Override
        public CreateableSubjectAccessReview createNew() {
            return this;
        }

        @Override
        public SubjectAccessReviewResponse done() {
            return this.create(this.builder.build());
        }
    }

    private class CreateableLocalSubjectAccessReviewImpl
    extends CreateableLocalSubjectAccessReview {
        private final OkHttpClient client;
        private final LocalSubjectAccessReviewBuilder builder;

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new LocalSubjectAccessReviewBuilder(this);
        }

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client, LocalSubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        @Override
        public SubjectAccessReviewResponse create(LocalSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)SubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public SubjectAccessReviewResponse create(LocalSubjectAccessReview resource) {
            return this.create(new LocalSubjectAccessReview[]{resource});
        }

        @Override
        public CreateableLocalSubjectAccessReview createNew() {
            return this;
        }

        @Override
        public SubjectAccessReviewResponse done() {
            return this.create(this.builder.build());
        }
    }
}

