/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_9;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Nested;
import io.fabric8.kubernetes.api.model.v4_9.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v4_9.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_9.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v4_9.SecretSpec;
import io.fabric8.openshift.api.model.v4_9.SecretSpecFluent;

public class SecretSpecFluentImpl<A extends SecretSpecFluent<A>>
extends BaseFluent<A>
implements SecretSpecFluent<A> {
    private String mountPath;
    private LocalObjectReferenceBuilder secretSource;

    public SecretSpecFluentImpl() {
    }

    public SecretSpecFluentImpl(SecretSpec instance) {
        this.withMountPath(instance.getMountPath());
        this.withSecretSource(instance.getSecretSource());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    public A withNewMountPath(String arg1) {
        return this.withMountPath(new String(arg1));
    }

    @Override
    public A withNewMountPath(StringBuilder arg1) {
        return this.withMountPath(new String(arg1));
    }

    @Override
    public A withNewMountPath(StringBuffer arg1) {
        return this.withMountPath(new String(arg1));
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretSource() {
        return this.secretSource != null ? this.secretSource.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretSource() {
        return this.secretSource != null ? this.secretSource.build() : null;
    }

    @Override
    public A withSecretSource(LocalObjectReference secretSource) {
        this._visitables.get("secretSource").remove(this.secretSource);
        if (secretSource != null) {
            this.secretSource = new LocalObjectReferenceBuilder(secretSource);
            this._visitables.get("secretSource").add(this.secretSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretSource() {
        return this.secretSource != null;
    }

    @Override
    public A withNewSecretSource(String name) {
        return this.withSecretSource(new LocalObjectReference(name));
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSource() {
        return new SecretSourceNestedImpl();
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item) {
        return new SecretSourceNestedImpl(item);
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource());
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource() != null ? this.getSecretSource() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSourceLike(LocalObjectReference item) {
        return this.withNewSecretSourceLike(this.getSecretSource() != null ? this.getSecretSource() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretSpecFluentImpl that = (SecretSpecFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        return !(this.secretSource != null ? !this.secretSource.equals(that.secretSource) : that.secretSource != null);
    }

    public class SecretSourceNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretSpecFluent.SecretSourceNested<N>>
    implements SecretSpecFluent.SecretSourceNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretSourceNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretSourceNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretSpecFluentImpl.this.withSecretSource(this.builder.build());
        }

        @Override
        public N endSecretSource() {
            return this.and();
        }
    }
}

