/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_9;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Nested;
import io.fabric8.kubernetes.api.builder.v4_9.Predicate;
import io.fabric8.kubernetes.api.model.v4_9.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v4_9.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_9.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_9.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_9.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_9.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v4_9.ImageSource;
import io.fabric8.openshift.api.model.v4_9.ImageSourceFluent;
import io.fabric8.openshift.api.model.v4_9.ImageSourcePath;
import io.fabric8.openshift.api.model.v4_9.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.v4_9.ImageSourcePathFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ImageSourceFluentImpl<A extends ImageSourceFluent<A>>
extends BaseFluent<A>
implements ImageSourceFluent<A> {
    private List<String> as = new ArrayList<String>();
    private ObjectReferenceBuilder from;
    private List<ImageSourcePathBuilder> paths = new ArrayList<ImageSourcePathBuilder>();
    private LocalObjectReferenceBuilder pullSecret;

    public ImageSourceFluentImpl() {
    }

    public ImageSourceFluentImpl(ImageSource instance) {
        this.withAs(instance.getAs());
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    public A addToAs(int index, String item) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        this.as.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAs(int index, String item) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        this.as.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAs(String ... items) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        for (String item : items) {
            this.as.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAs(Collection<String> items) {
        if (this.as == null) {
            this.as = new ArrayList<String>();
        }
        for (String item : items) {
            this.as.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAs(String ... items) {
        for (String item : items) {
            if (this.as == null) continue;
            this.as.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAs(Collection<String> items) {
        for (String item : items) {
            if (this.as == null) continue;
            this.as.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAs() {
        return this.as;
    }

    @Override
    public String getA(int index) {
        return this.as.get(index);
    }

    @Override
    public String getFirstA() {
        return this.as.get(0);
    }

    @Override
    public String getLastA() {
        return this.as.get(this.as.size() - 1);
    }

    @Override
    public String getMatchingA(Predicate<String> predicate) {
        for (String item : this.as) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingA(Predicate<String> predicate) {
        for (String item : this.as) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAs(List<String> as) {
        if (this.as != null) {
            this._visitables.get("as").removeAll(this.as);
        }
        if (as != null) {
            this.as = new ArrayList<String>();
            for (String item : as) {
                this.addToAs(item);
            }
        } else {
            this.as = null;
        }
        return (A)this;
    }

    @Override
    public A withAs(String ... as) {
        if (this.as != null) {
            this.as.clear();
        }
        if (as != null) {
            for (String item : as) {
                this.addToAs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAs() {
        return this.as != null && !this.as.isEmpty();
    }

    @Override
    public A addNewA(String arg1) {
        return this.addToAs(new String(arg1));
    }

    @Override
    public A addNewA(StringBuilder arg1) {
        return this.addToAs(new String(arg1));
    }

    @Override
    public A addNewA(StringBuffer arg1) {
        return this.addToAs(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public ImageSourceFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public ImageSourceFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public ImageSourceFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public ImageSourceFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public A addToPaths(int index, ImageSourcePath item) {
        if (this.paths == null) {
            this.paths = new ArrayList<ImageSourcePathBuilder>();
        }
        ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
        this._visitables.get("paths").add(index >= 0 ? index : this._visitables.get("paths").size(), builder);
        this.paths.add(index >= 0 ? index : this.paths.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPaths(int index, ImageSourcePath item) {
        if (this.paths == null) {
            this.paths = new ArrayList<ImageSourcePathBuilder>();
        }
        ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
        if (index < 0 || index >= this._visitables.get("paths").size()) {
            this._visitables.get("paths").add(builder);
        } else {
            this._visitables.get("paths").set(index, builder);
        }
        if (index < 0 || index >= this.paths.size()) {
            this.paths.add(builder);
        } else {
            this.paths.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPaths(ImageSourcePath ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<ImageSourcePathBuilder>();
        }
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<ImageSourcePath> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<ImageSourcePathBuilder>();
        }
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get("paths").remove(builder);
            if (this.paths == null) continue;
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<ImageSourcePath> items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.get("paths").remove(builder);
            if (this.paths == null) continue;
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPaths(Predicate<ImageSourcePathBuilder> predicate) {
        if (this.paths == null) {
            return (A)this;
        }
        Iterator<ImageSourcePathBuilder> each = this.paths.iterator();
        Object visitables = this._visitables.get("paths");
        while (each.hasNext()) {
            ImageSourcePathBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageSourcePath> getPaths() {
        return ImageSourceFluentImpl.build(this.paths);
    }

    @Override
    public List<ImageSourcePath> buildPaths() {
        return ImageSourceFluentImpl.build(this.paths);
    }

    @Override
    public ImageSourcePath buildPath(int index) {
        return this.paths.get(index).build();
    }

    @Override
    public ImageSourcePath buildFirstPath() {
        return this.paths.get(0).build();
    }

    @Override
    public ImageSourcePath buildLastPath() {
        return this.paths.get(this.paths.size() - 1).build();
    }

    @Override
    public ImageSourcePath buildMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        for (ImageSourcePathBuilder item : this.paths) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        for (ImageSourcePathBuilder item : this.paths) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<ImageSourcePath> paths) {
        if (this.paths != null) {
            this._visitables.get("paths").removeAll(this.paths);
        }
        if (paths != null) {
            this.paths = new ArrayList<ImageSourcePathBuilder>();
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(ImageSourcePath ... paths) {
        if (this.paths != null) {
            this.paths.clear();
        }
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public A addNewPath(String destinationDir, String sourcePath) {
        return this.addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }

    @Override
    public ImageSourceFluent.PathsNested<A> addNewPath() {
        return new PathsNestedImpl();
    }

    @Override
    public ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item) {
        return new PathsNestedImpl(-1, item);
    }

    @Override
    public ImageSourceFluent.PathsNested<A> setNewPathLike(int index, ImageSourcePath item) {
        return new PathsNestedImpl(index, item);
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editPath(int index) {
        if (this.paths.size() <= index) {
            throw new RuntimeException("Can't edit paths. Index exceeds size.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editFirstPath() {
        if (this.paths.size() == 0) {
            throw new RuntimeException("Can't edit first paths. The list is empty.");
        }
        return this.setNewPathLike(0, this.buildPath(0));
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editLastPath() {
        int index = this.paths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last paths. The list is empty.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!predicate.apply(this.paths.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching paths. No match found.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get("pullSecret").add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageSourceFluentImpl that = (ImageSourceFluentImpl)o;
        if (this.as != null ? !this.as.equals(that.as) : that.as != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        return !(this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null);
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ImageSourceFluent.PullSecretNested<N>>
    implements ImageSourceFluent.PullSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class PathsNestedImpl<N>
    extends ImageSourcePathFluentImpl<ImageSourceFluent.PathsNested<N>>
    implements ImageSourceFluent.PathsNested<N>,
    Nested<N> {
        private final ImageSourcePathBuilder builder;
        private final int index;

        PathsNestedImpl(int index, ImageSourcePath item) {
            this.index = index;
            this.builder = new ImageSourcePathBuilder(this, item);
        }

        PathsNestedImpl() {
            this.index = -1;
            this.builder = new ImageSourcePathBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.setToPaths(this.index, this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<ImageSourceFluent.FromNested<N>>
    implements ImageSourceFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

