/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_9;

import io.fabric8.kubernetes.api.model.v4_9.Node;
import io.fabric8.kubernetes.api.model.v4_9.NodeAddress;
import io.fabric8.kubernetes.api.model.v4_9.NodeList;
import io.fabric8.kubernetes.api.model.v4_9.NodeStatus;
import io.fabric8.kubernetes.api.model.v4_9.Service;
import io.fabric8.kubernetes.api.model.v4_9.ServicePort;
import io.fabric8.kubernetes.clnt.v4_9.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_9.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v4_9.utils.URLFromServiceUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLFromNodePortImpl
implements ServiceToURLProvider {
    public static Logger logger = LoggerFactory.getLogger(URLFromNodePortImpl.class);

    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        String serviceProto = port.getProtocol();
        NodePortUrlComponents urlComponents = null;
        Integer nodePort = port.getNodePort();
        if (nodePort != null) {
            try {
                NodeList nodeList = (NodeList)client.nodes().list();
                if (nodeList != null && nodeList.getItems() != null) {
                    Node item;
                    Iterator<Node> iterator = nodeList.getItems().iterator();
                    while (iterator.hasNext() && (urlComponents = this.getUrlComponentsFromNodeList((item = iterator.next()).getStatus(), nodePort)) == null) {
                    }
                }
            }
            catch (KubernetesClientException exception) {
                logger.warn("Could not find a node! " + exception);
            }
        }
        return urlComponents != null ? (serviceProto + "://" + urlComponents.getClusterIP() + ":" + urlComponents.getPortNumber()).toLowerCase(Locale.ROOT) : null;
    }

    private NodePortUrlComponents getUrlComponentsFromNodeList(NodeStatus nodeStatus, Integer nodePort) {
        if (nodeStatus != null) {
            List<NodeAddress> addresses = nodeStatus.getAddresses();
            for (NodeAddress address : addresses) {
                String ip = address.getAddress();
                if (ip.isEmpty()) continue;
                return new NodePortUrlComponents(ip, nodePort);
            }
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.SECOND.getValue();
    }

    private class NodePortUrlComponents {
        private String clusterIP;
        private Integer portNumber;

        public String getClusterIP() {
            return this.clusterIP;
        }

        public Integer getPortNumber() {
            return this.portNumber;
        }

        public NodePortUrlComponents(String clusterIP, Integer portNumber) {
            this.clusterIP = clusterIP;
            this.portNumber = portNumber;
        }
    }
}

