/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_9;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Nested;
import io.fabric8.kubernetes.api.builder.v4_9.Predicate;
import io.fabric8.kubernetes.api.model.v4_9.ReplicationControllerCondition;
import io.fabric8.kubernetes.api.model.v4_9.ReplicationControllerConditionBuilder;
import io.fabric8.kubernetes.api.model.v4_9.ReplicationControllerConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v4_9.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.v4_9.ReplicationControllerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ReplicationControllerStatusFluentImpl<A extends ReplicationControllerStatusFluent<A>>
extends BaseFluent<A>
implements ReplicationControllerStatusFluent<A> {
    private Integer availableReplicas;
    private List<ReplicationControllerConditionBuilder> conditions = new ArrayList<ReplicationControllerConditionBuilder>();
    private Integer fullyLabeledReplicas;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;

    public ReplicationControllerStatusFluentImpl() {
    }

    public ReplicationControllerStatusFluentImpl(ReplicationControllerStatus instance) {
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
    }

    @Override
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    @Override
    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    @Override
    public A addToConditions(int index, ReplicationControllerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicationControllerConditionBuilder>();
        }
        ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, ReplicationControllerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicationControllerConditionBuilder>();
        }
        ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(ReplicationControllerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicationControllerConditionBuilder>();
        }
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<ReplicationControllerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ReplicationControllerConditionBuilder>();
        }
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ReplicationControllerCondition ... items) {
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<ReplicationControllerCondition> items) {
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ReplicationControllerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ReplicationControllerConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ReplicationControllerConditionBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ReplicationControllerCondition> getConditions() {
        return ReplicationControllerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<ReplicationControllerCondition> buildConditions() {
        return ReplicationControllerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public ReplicationControllerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public ReplicationControllerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public ReplicationControllerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public ReplicationControllerCondition buildMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate) {
        for (ReplicationControllerConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate) {
        for (ReplicationControllerConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<ReplicationControllerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ReplicationControllerConditionBuilder>();
            for (ReplicationControllerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(ReplicationControllerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (ReplicationControllerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ReplicationControllerCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public ReplicationControllerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ReplicationControllerStatusFluent.ConditionsNested<A> addNewConditionLike(ReplicationControllerCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ReplicationControllerStatusFluent.ConditionsNested<A> setNewConditionLike(int index, ReplicationControllerCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ReplicationControllerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ReplicationControllerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ReplicationControllerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ReplicationControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    @Override
    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasFullyLabeledReplicas() {
        return this.fullyLabeledReplicas != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    @Override
    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationControllerStatusFluentImpl that = (ReplicationControllerStatusFluentImpl)o;
        if (this.availableReplicas != null ? !this.availableReplicas.equals(that.availableReplicas) : that.availableReplicas != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.fullyLabeledReplicas != null ? !this.fullyLabeledReplicas.equals(that.fullyLabeledReplicas) : that.fullyLabeledReplicas != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.readyReplicas != null ? !this.readyReplicas.equals(that.readyReplicas) : that.readyReplicas != null) {
            return false;
        }
        return !(this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null);
    }

    public class ConditionsNestedImpl<N>
    extends ReplicationControllerConditionFluentImpl<ReplicationControllerStatusFluent.ConditionsNested<N>>
    implements ReplicationControllerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final ReplicationControllerConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, ReplicationControllerCondition item) {
            this.index = index;
            this.builder = new ReplicationControllerConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ReplicationControllerConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicationControllerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

