/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_8.handlers;

import io.fabric8.kubernetes.clnt.v4_8.Config;
import io.fabric8.kubernetes.clnt.v4_8.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_8.Watch;
import io.fabric8.kubernetes.clnt.v4_8.Watcher;
import io.fabric8.kubernetes.clnt.v4_8.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_8.dsl.Resource;
import io.fabric8.openshift.api.model.v4_8.NetNamespace;
import io.fabric8.openshift.api.model.v4_8.NetNamespaceBuilder;
import io.fabric8.openshift.clnt.v4_8.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_8.dsl.internal.NetNamespaceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NetNamespaceHandler
implements ResourceHandler<NetNamespace, NetNamespaceBuilder> {
    @Override
    public String getKind() {
        return NetNamespace.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "network.openshift.io/v1";
    }

    @Override
    public NetNamespace create(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new NetNamespace[0]);
    }

    @Override
    public NetNamespace replace(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public NetNamespace reload(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)((Gettable)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NetNamespaceBuilder edit(NetNamespace item) {
        return new NetNamespaceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, NetNamespace item) {
        if (cascading.booleanValue()) {
            return (Boolean)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, Watcher<NetNamespace> watcher) {
        return (Watch)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, String resourceVersion, Watcher<NetNamespace> watcher) {
        return (Watch)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public NetNamespace waitUntilReady(OkHttpClient client, Config config, String namespace, NetNamespace item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public NetNamespace waitUntilCondition(OkHttpClient client, Config config, String namespace, NetNamespace item, Predicate<NetNamespace> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

