/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_8.handlers;

import io.fabric8.kubernetes.clnt.v4_8.Config;
import io.fabric8.kubernetes.clnt.v4_8.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_8.Watch;
import io.fabric8.kubernetes.clnt.v4_8.Watcher;
import io.fabric8.kubernetes.clnt.v4_8.dsl.Gettable;
import io.fabric8.openshift.api.model.v4_8.Build;
import io.fabric8.openshift.api.model.v4_8.BuildBuilder;
import io.fabric8.openshift.clnt.v4_8.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_8.dsl.BuildResource;
import io.fabric8.openshift.clnt.v4_8.dsl.internal.BuildOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class BuildHandler
implements ResourceHandler<Build, BuildBuilder> {
    @Override
    public String getKind() {
        return Build.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "build.openshift.io/v1";
    }

    @Override
    public Build create(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Build[0]);
    }

    @Override
    public Build replace(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Build reload(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((Gettable)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public BuildBuilder edit(Build item) {
        return new BuildBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Build item) {
        if (cascading.booleanValue()) {
            return (Boolean)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, String resourceVersion, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Build waitUntilReady(OkHttpClient client, Config config, String namespace, Build item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Build waitUntilCondition(OkHttpClient client, Config config, String namespace, Build item, Predicate<Build> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

