/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_8.informers.cache;

import io.fabric8.kubernetes.clnt.v4_8.informers.cache.ProcessorListener;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SharedProcessor<T> {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<ProcessorListener<T>> listeners = new ArrayList<ProcessorListener<T>>();
    private List<ProcessorListener<T>> syncingListeners = new ArrayList<ProcessorListener<T>>();
    private ExecutorService executorService;

    public SharedProcessor() {
        this(Executors.newCachedThreadPool());
    }

    public SharedProcessor(ExecutorService threadPool) {
        this.executorService = threadPool;
    }

    public void addAndStartListener(ProcessorListener<T> processorListener) {
        this.lock.writeLock().lock();
        try {
            this.addListenerLocked(processorListener);
            this.executorService.execute(processorListener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addListener(ProcessorListener<T> processorListener) {
        this.lock.writeLock().lock();
        try {
            this.addListenerLocked(processorListener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addListenerLocked(ProcessorListener<T> processorListener) {
        this.listeners.add(processorListener);
        this.syncingListeners.add(processorListener);
    }

    public void run() {
        this.lock.readLock().lock();
        try {
            if (this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            for (ProcessorListener<T> listener : this.listeners) {
                this.executorService.submit(listener);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distribute(ProcessorListener.Notification<T> obj, boolean isSync) {
        this.lock.readLock().lock();
        try {
            if (isSync) {
                for (ProcessorListener<T> listener : this.syncingListeners) {
                    listener.add(obj);
                }
            } else {
                for (ProcessorListener<T> listener : this.listeners) {
                    listener.add(obj);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldResync() {
        this.lock.writeLock().lock();
        boolean resyncNeeded = false;
        try {
            this.syncingListeners = new ArrayList<ProcessorListener<T>>();
            ZonedDateTime now = ZonedDateTime.now();
            for (ProcessorListener<T> listener : this.listeners) {
                if (!listener.shouldResync(now)) continue;
                resyncNeeded = true;
                this.syncingListeners.add(listener);
                listener.determineNextResync(now);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return resyncNeeded;
    }

    public void stop() {
        this.lock.writeLock().lock();
        try {
            this.listeners = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.executorService.shutdownNow();
    }
}

