/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_8.informers.cache;

import io.fabric8.kubernetes.api.model.v4_8.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_8.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v4_8.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_8.informers.ListerWatcher;
import io.fabric8.kubernetes.clnt.v4_8.informers.ResyncRunnable;
import io.fabric8.kubernetes.clnt.v4_8.informers.cache.DeltaFIFO;
import io.fabric8.kubernetes.clnt.v4_8.informers.cache.ReflectorRunnable;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller<T extends HasMetadata, TList extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private static final long DEFAULT_PERIOD = 5000L;
    private static final long DEFAULT_DELAY_PERIOD = 1000L;
    private long fullResyncPeriod;
    private DeltaFIFO<T> queue;
    private ListerWatcher<T, TList> listerWatcher;
    private ReflectorRunnable<T, TList> reflector;
    private Supplier<Boolean> resyncFunc;
    private Consumer<Deque<AbstractMap.SimpleEntry<DeltaFIFO.DeltaType, Object>>> processFunc;
    private ScheduledExecutorService reflectExecutor;
    private ScheduledExecutorService resyncExecutor;
    private ScheduledFuture resyncFuture;
    private OperationContext operationContext;
    private Class<T> apiTypeClass;
    private ScheduledFuture reflectorFuture;

    public Controller(Class<T> apiTypeClass, DeltaFIFO<T> queue, ListerWatcher<T, TList> listerWatcher, Consumer<Deque<AbstractMap.SimpleEntry<DeltaFIFO.DeltaType, Object>>> processFunc, Supplier<Boolean> resyncFunc, long fullResyncPeriod, OperationContext context) {
        this.queue = queue;
        this.listerWatcher = listerWatcher;
        this.apiTypeClass = apiTypeClass;
        this.processFunc = processFunc;
        this.resyncFunc = resyncFunc;
        this.fullResyncPeriod = fullResyncPeriod;
        this.operationContext = context;
        this.reflectExecutor = Executors.newSingleThreadScheduledExecutor();
        this.resyncExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public Controller(Class<T> apiTypeClass, DeltaFIFO<T> queue, ListerWatcher<T, TList> listerWatcher, Consumer<Deque<AbstractMap.SimpleEntry<DeltaFIFO.DeltaType, Object>>> popProcessFunc, OperationContext context) {
        this(apiTypeClass, queue, listerWatcher, popProcessFunc, null, 0L, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info("informer#Controller: ready to run resync and reflector runnable");
        if (this.fullResyncPeriod > 0L) {
            ResyncRunnable<Object> resyncRunnable = new ResyncRunnable<Object>(this.queue, this.resyncFunc);
            this.resyncFuture = this.resyncExecutor.scheduleAtFixedRate(resyncRunnable::run, this.fullResyncPeriod, this.fullResyncPeriod, TimeUnit.MILLISECONDS);
        } else {
            log.info("informer#Controller: resync skipped due to 0 full resync period");
        }
        Controller controller = this;
        synchronized (controller) {
            this.reflector = new ReflectorRunnable(this.apiTypeClass, this.listerWatcher, this.queue, this.operationContext);
            try {
                this.reflectorFuture = this.fullResyncPeriod > 0L ? this.reflectExecutor.scheduleWithFixedDelay(this.reflector::run, 1000L, this.fullResyncPeriod, TimeUnit.MILLISECONDS) : this.reflectExecutor.scheduleWithFixedDelay(this.reflector::run, 1000L, 5000L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                log.warn("reflector list-watching job exiting because the thread-pool is shutting down");
                return;
            }
        }
        this.processLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Controller controller = this;
        synchronized (controller) {
            if (this.reflectorFuture != null) {
                this.reflector.stop();
                this.reflectorFuture.cancel(true);
            }
            this.reflectExecutor.shutdown();
        }
    }

    public boolean hasSynced() {
        return this.queue.hasSynced();
    }

    public String lastSyncResourceVersion() {
        if (this.reflector == null) {
            return "";
        }
        return this.reflector.getLastSyncResourceVersion();
    }

    private void processLoop() {
        while (true) {
            try {
                while (true) {
                    this.queue.pop(this.processFunc);
                }
            }
            catch (InterruptedException t) {
                log.error("DefaultController#processLoop got interrupted {}", (Object)t.getMessage(), (Object)t);
                return;
            }
            catch (Throwable t) {
                log.error("DefaultController#processLoop recovered from crashing {} ", (Object)t.getMessage(), (Object)t);
                continue;
            }
            break;
        }
    }
}

