/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_8.informers;

import io.fabric8.kubernetes.api.model.v4_8.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_8.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_8.ListOptions;
import io.fabric8.kubernetes.clnt.v4_8.Config;
import io.fabric8.kubernetes.clnt.v4_8.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_8.Watch;
import io.fabric8.kubernetes.clnt.v4_8.Watcher;
import io.fabric8.kubernetes.clnt.v4_8.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v4_8.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v4_8.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_8.informers.ListerWatcher;
import io.fabric8.kubernetes.clnt.v4_8.informers.SharedIndexInformer;
import io.fabric8.kubernetes.clnt.v4_8.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.clnt.v4_8.internal.KubernetesDeserializer;
import io.fabric8.kubernetes.clnt.v4_8.utils.Utils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import okhttp3.OkHttpClient;

public class SharedInformerFactory
extends BaseOperation {
    private Map<Type, SharedIndexInformer> informers;
    private Map<Type, Future> startedInformers;
    private ExecutorService informerExecutor;
    private BaseOperation baseOperation;

    public SharedInformerFactory(ExecutorService threadPool, OkHttpClient okHttpClient, Config configuration) {
        super(new OperationContext().withOkhttpClient(okHttpClient).withConfig(configuration));
        this.informerExecutor = threadPool;
        this.informers = new HashMap<Type, SharedIndexInformer>();
        this.startedInformers = new HashMap<Type, Future>();
        this.baseOperation = this.newInstance(this.context);
    }

    public synchronized <T extends HasMetadata, TList extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<TList> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withPlural(Utils.getPluralFromKind(apiTypeClass.getSimpleName())), resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata, TList extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext customResourceContext, Class<T> apiTypeClass, Class<TList> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withApiGroupVersion(customResourceContext.getVersion()).withApiGroupName(customResourceContext.getGroup()).withPlural(customResourceContext.getPlural()), resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata, TList extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<TList> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        ListerWatcher<T, TList> listerWatcher = this.listerWatcherFor(apiTypeClass, apiListTypeClass);
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(apiTypeClass, listerWatcher, resyncPeriodInMillis, operationContext);
        this.informers.put(apiTypeClass, informer);
        return informer;
    }

    private <T extends HasMetadata, TList extends KubernetesResourceList<T>> ListerWatcher<T, TList> listerWatcherFor(final Class<T> apiTypeClass, final Class<TList> apiListTypeClass) {
        return new ListerWatcher<T, TList>(){

            @Override
            public TList list(ListOptions params, String namespace, OperationContext context) throws KubernetesClientException {
                BaseOperation listBaseOperation = SharedInformerFactory.this.baseOperation.newInstance(context.withNamespace(namespace));
                listBaseOperation.setType(apiTypeClass);
                listBaseOperation.setListType(apiListTypeClass);
                return listBaseOperation.list();
            }

            @Override
            public Watch watch(ListOptions params, String namespace, OperationContext context, Watcher<T> resourceWatcher) throws KubernetesClientException {
                BaseOperation watchBaseOperation = SharedInformerFactory.this.baseOperation.newInstance(context);
                watchBaseOperation.setType(apiTypeClass);
                watchBaseOperation.setListType(apiListTypeClass);
                if (context.getApiGroupName() != null && context.getApiGroupVersion() != null) {
                    String apiGroupNameAndVersion = context.getApiGroupName() + (context.getApiGroupName().endsWith("/") ? context.getApiGroupVersion() : "/" + context.getApiGroupVersion());
                    KubernetesDeserializer.registerCustomKind(apiGroupNameAndVersion, apiTypeClass.getSimpleName(), apiTypeClass);
                }
                return watchBaseOperation.watch(params.getResourceVersion(), resourceWatcher);
            }
        };
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        return this.informers.get(apiTypeClass);
    }

    public synchronized void startAllRegisteredInformers() {
        if (this.informers == null || this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> this.startedInformers.computeIfAbsent((Type)informerType, key -> this.informerExecutor.submit(informer::run)));
    }

    public synchronized void stopAllRegisteredInformers() {
        this.stopAllRegisteredInformers(true);
    }

    public synchronized void stopAllRegisteredInformers(boolean shutDownThreadPool) {
        if (this.informers == null || this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (this.startedInformers.remove(informerType) != null) {
                informer.stop();
            }
        });
        if (shutDownThreadPool) {
            this.informerExecutor.shutdown();
        }
    }
}

