/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_8.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_8.Container;
import io.fabric8.kubernetes.api.model.v4_8.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v4_8.DoneablePod;
import io.fabric8.kubernetes.api.model.v4_8.OwnerReference;
import io.fabric8.kubernetes.api.model.v4_8.Pod;
import io.fabric8.kubernetes.api.model.v4_8.PodList;
import io.fabric8.kubernetes.api.model.v4_8.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_8.Status;
import io.fabric8.kubernetes.api.model.v4_8.apps.DoneableReplicaSet;
import io.fabric8.kubernetes.api.model.v4_8.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v4_8.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.v4_8.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.v4_8.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.v4_8.apps.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.api.model.v4_8.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v4_8.Config;
import io.fabric8.kubernetes.clnt.v4_8.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_8.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_8.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v4_8.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_8.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_8.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_8.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_8.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v4_8.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_8.dsl.internal.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.clnt.v4_8.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v4_8.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v4_8.dsl.internal.RollingUpdater;
import io.fabric8.kubernetes.clnt.v4_8.utils.KubernetesResourceUtil;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ReplicaSetOperationsImpl
extends RollableScalableResourceOperation<ReplicaSet, ReplicaSetList, DoneableReplicaSet, RollableScalableResource<ReplicaSet, DoneableReplicaSet>>
implements TimeoutImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> {
    public ReplicaSetOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withCascading(true));
    }

    public ReplicaSetOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("replicasets"));
        this.type = ReplicaSet.class;
        this.listType = ReplicaSetList.class;
        this.doneableType = DoneableReplicaSet.class;
    }

    public ReplicaSetOperationsImpl newInstance(OperationContext context) {
        return new ReplicaSetOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public ReplicaSet updateImage(String image) {
        ReplicaSet oldRC = (ReplicaSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicaSetBuilder newRCBuilder = new ReplicaSetBuilder(oldRC);
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new ReplicaSetRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    ReplicaSet withReplicas(int count) {
        return ((DoneableReplicaSet)((ReplicaSetFluent.SpecNested)((DoneableReplicaSet)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    RollingUpdater<ReplicaSet, ReplicaSetList, DoneableReplicaSet> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicaSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    int getCurrentReplicas(ReplicaSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(ReplicaSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(ReplicaSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public TimeoutImageEditReplacePatchable rolling() {
        return new ReplicaSetOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicaSets");
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicaSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(unit.toMillis(timeout)).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicaSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod, DoneablePod>> podOperationList = this.doGetLog(isPretty);
        for (PodResource<Pod, DoneablePod> podOperation : podOperationList) {
            stringBuilder.append((String)podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod, DoneablePod>> doGetLog(boolean isPretty) {
        ArrayList<PodResource<Pod, DoneablePod>> pods = new ArrayList<PodResource<Pod, DoneablePod>>();
        ReplicaSet replicaSet = (ReplicaSet)this.fromServer().get();
        String rcUid = replicaSet.getMetadata().getUid();
        PodOperationsImpl podOperations = new PodOperationsImpl(new PodOperationContext(this.context.getClient(), this.context.getConfig(), this.context.getPlural(), this.context.getNamespace(), this.context.getName(), null, "v1", this.context.getCascading(), this.context.getItem(), this.context.getLabels(), this.context.getLabelsNot(), this.context.getLabelsIn(), this.context.getLabelsNotIn(), this.context.getFields(), this.context.getFieldsNot(), this.context.getResourceVersion(), this.context.getReloadingFromServer(), this.context.getGracePeriodSeconds(), this.context.getPropagationPolicy(), null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, isPretty, null, null, null, null, null));
        PodList jobPodList = (PodList)podOperations.withLabels((Map)replicaSet.getMetadata().getLabels()).list();
        for (Pod pod : jobPodList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(pod);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            pods.add((PodResource<Pod, DoneablePod>)podOperations.withName(pod.getMetadata().getName()));
        }
        return pods;
    }

    @Override
    public Reader getLogReader() {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }
}

