/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_8;

import io.fabric8.kubernetes.api.builder.v4_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_8.Namespace;
import io.fabric8.kubernetes.api.model.v4_8.NamespaceFluent;
import io.fabric8.kubernetes.api.model.v4_8.NamespaceFluentImpl;

public class NamespaceBuilder
extends NamespaceFluentImpl<NamespaceBuilder>
implements VisitableBuilder<Namespace, NamespaceBuilder> {
    NamespaceFluent<?> fluent;
    Boolean validationEnabled;

    public NamespaceBuilder() {
        this(true);
    }

    public NamespaceBuilder(Boolean validationEnabled) {
        this(new Namespace(), validationEnabled);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Namespace(), validationEnabled);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent, Namespace instance) {
        this(fluent, instance, true);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent, Namespace instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public NamespaceBuilder(Namespace instance) {
        this(instance, (Boolean)true);
    }

    public NamespaceBuilder(Namespace instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Namespace build() {
        Namespace buildable = new Namespace(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceBuilder that = (NamespaceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

