/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_8;

import io.fabric8.kubernetes.api.builder.v4_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_8.Nested;
import io.fabric8.kubernetes.api.model.v4_8.MetricValueStatus;
import io.fabric8.kubernetes.api.model.v4_8.MetricValueStatusFluent;
import io.fabric8.kubernetes.api.model.v4_8.Quantity;
import io.fabric8.kubernetes.api.model.v4_8.QuantityBuilder;
import io.fabric8.kubernetes.api.model.v4_8.QuantityFluentImpl;

public class MetricValueStatusFluentImpl<A extends MetricValueStatusFluent<A>>
extends BaseFluent<A>
implements MetricValueStatusFluent<A> {
    private Integer averageUtilization;
    private QuantityBuilder averageValue;
    private QuantityBuilder value;

    public MetricValueStatusFluentImpl() {
    }

    public MetricValueStatusFluentImpl(MetricValueStatus instance) {
        this.withAverageUtilization(instance.getAverageUtilization());
        this.withAverageValue(instance.getAverageValue());
        this.withValue(instance.getValue());
    }

    @Override
    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    @Override
    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    @Override
    @Deprecated
    public Quantity getAverageValue() {
        return this.averageValue != null ? this.averageValue.build() : null;
    }

    @Override
    public Quantity buildAverageValue() {
        return this.averageValue != null ? this.averageValue.build() : null;
    }

    @Override
    public A withAverageValue(Quantity averageValue) {
        this._visitables.get("averageValue").remove(this.averageValue);
        if (averageValue != null) {
            this.averageValue = new QuantityBuilder(averageValue);
            this._visitables.get("averageValue").add(this.averageValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    @Override
    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    @Override
    public MetricValueStatusFluent.AverageValueNested<A> withNewAverageValue() {
        return new AverageValueNestedImpl();
    }

    @Override
    public MetricValueStatusFluent.AverageValueNested<A> withNewAverageValueLike(Quantity item) {
        return new AverageValueNestedImpl(item);
    }

    @Override
    public MetricValueStatusFluent.AverageValueNested<A> editAverageValue() {
        return this.withNewAverageValueLike(this.getAverageValue());
    }

    @Override
    public MetricValueStatusFluent.AverageValueNested<A> editOrNewAverageValue() {
        return this.withNewAverageValueLike(this.getAverageValue() != null ? this.getAverageValue() : new QuantityBuilder().build());
    }

    @Override
    public MetricValueStatusFluent.AverageValueNested<A> editOrNewAverageValueLike(Quantity item) {
        return this.withNewAverageValueLike(this.getAverageValue() != null ? this.getAverageValue() : item);
    }

    @Override
    @Deprecated
    public Quantity getValue() {
        return this.value != null ? this.value.build() : null;
    }

    @Override
    public Quantity buildValue() {
        return this.value != null ? this.value.build() : null;
    }

    @Override
    public A withValue(Quantity value) {
        this._visitables.get("value").remove(this.value);
        if (value != null) {
            this.value = new QuantityBuilder(value);
            this._visitables.get("value").add(this.value);
        }
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    @Override
    public A withNewValue(String amount, String format) {
        return this.withValue(new Quantity(amount, format));
    }

    @Override
    public A withNewValue(String amount) {
        return this.withValue(new Quantity(amount));
    }

    @Override
    public MetricValueStatusFluent.ValueNested<A> withNewValue() {
        return new ValueNestedImpl();
    }

    @Override
    public MetricValueStatusFluent.ValueNested<A> withNewValueLike(Quantity item) {
        return new ValueNestedImpl(item);
    }

    @Override
    public MetricValueStatusFluent.ValueNested<A> editValue() {
        return this.withNewValueLike(this.getValue());
    }

    @Override
    public MetricValueStatusFluent.ValueNested<A> editOrNewValue() {
        return this.withNewValueLike(this.getValue() != null ? this.getValue() : new QuantityBuilder().build());
    }

    @Override
    public MetricValueStatusFluent.ValueNested<A> editOrNewValueLike(Quantity item) {
        return this.withNewValueLike(this.getValue() != null ? this.getValue() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricValueStatusFluentImpl that = (MetricValueStatusFluentImpl)o;
        if (this.averageUtilization != null ? !this.averageUtilization.equals(that.averageUtilization) : that.averageUtilization != null) {
            return false;
        }
        if (this.averageValue != null ? !this.averageValue.equals(that.averageValue) : that.averageValue != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public class ValueNestedImpl<N>
    extends QuantityFluentImpl<MetricValueStatusFluent.ValueNested<N>>
    implements MetricValueStatusFluent.ValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        ValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        ValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)MetricValueStatusFluentImpl.this.withValue(this.builder.build());
        }

        @Override
        public N endValue() {
            return this.and();
        }
    }

    public class AverageValueNestedImpl<N>
    extends QuantityFluentImpl<MetricValueStatusFluent.AverageValueNested<N>>
    implements MetricValueStatusFluent.AverageValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        AverageValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        AverageValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)MetricValueStatusFluentImpl.this.withAverageValue(this.builder.build());
        }

        @Override
        public N endAverageValue() {
            return this.and();
        }
    }
}

