/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.TagImportPolicy;
import io.fabric8.openshift.api.model.TagImportPolicyBuilder;
import io.fabric8.openshift.api.model.TagImportPolicyFluentImpl;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import io.fabric8.openshift.api.model.TagReferencePolicy;
import io.fabric8.openshift.api.model.TagReferencePolicyBuilder;
import io.fabric8.openshift.api.model.TagReferencePolicyFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;

public class TagReferenceFluentImpl<A extends TagReferenceFluent<A>>
extends BaseFluent<A>
implements TagReferenceFluent<A> {
    private Map<String, String> annotations;
    private ObjectReferenceBuilder from;
    private Long generation;
    private TagImportPolicyBuilder importPolicy;
    private String name;
    private Boolean reference;
    private TagReferencePolicyBuilder referencePolicy;

    public TagReferenceFluentImpl() {
    }

    public TagReferenceFluentImpl(TagReference instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withFrom(instance.getFrom());
        this.withGeneration(instance.getGeneration());
        this.withImportPolicy(instance.getImportPolicy());
        this.withName(instance.getName());
        this.withReference(instance.getReference());
        this.withReferencePolicy(instance.getReferencePolicy());
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public TagReferenceFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public TagReferenceFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public TagReferenceFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public TagReferenceFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public TagReferenceFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public Boolean hasGeneration() {
        return this.generation != null;
    }

    @Override
    @Deprecated
    public TagImportPolicy getImportPolicy() {
        return this.importPolicy != null ? this.importPolicy.build() : null;
    }

    @Override
    public TagImportPolicy buildImportPolicy() {
        return this.importPolicy != null ? this.importPolicy.build() : null;
    }

    @Override
    public A withImportPolicy(TagImportPolicy importPolicy) {
        this._visitables.get("importPolicy").remove(this.importPolicy);
        if (importPolicy != null) {
            this.importPolicy = new TagImportPolicyBuilder(importPolicy);
            this._visitables.get("importPolicy").add(this.importPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImportPolicy() {
        return this.importPolicy != null;
    }

    @Override
    public A withNewImportPolicy(Boolean insecure, Boolean scheduled) {
        return this.withImportPolicy(new TagImportPolicy(insecure, scheduled));
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicy() {
        return new ImportPolicyNestedImpl();
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
        return new ImportPolicyNestedImpl(item);
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> editImportPolicy() {
        return this.withNewImportPolicyLike(this.getImportPolicy());
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> editOrNewImportPolicy() {
        return this.withNewImportPolicyLike(this.getImportPolicy() != null ? this.getImportPolicy() : new TagImportPolicyBuilder().build());
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
        return this.withNewImportPolicyLike(this.getImportPolicy() != null ? this.getImportPolicy() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public Boolean isReference() {
        return this.reference;
    }

    @Override
    public A withReference(Boolean reference) {
        this.reference = reference;
        return (A)this;
    }

    @Override
    public Boolean hasReference() {
        return this.reference != null;
    }

    @Override
    public A withNewReference(String arg1) {
        return this.withReference(new Boolean(arg1));
    }

    @Override
    public A withNewReference(boolean arg1) {
        return this.withReference(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public TagReferencePolicy getReferencePolicy() {
        return this.referencePolicy != null ? this.referencePolicy.build() : null;
    }

    @Override
    public TagReferencePolicy buildReferencePolicy() {
        return this.referencePolicy != null ? this.referencePolicy.build() : null;
    }

    @Override
    public A withReferencePolicy(TagReferencePolicy referencePolicy) {
        this._visitables.get("referencePolicy").remove(this.referencePolicy);
        if (referencePolicy != null) {
            this.referencePolicy = new TagReferencePolicyBuilder(referencePolicy);
            this._visitables.get("referencePolicy").add(this.referencePolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReferencePolicy() {
        return this.referencePolicy != null;
    }

    @Override
    public A withNewReferencePolicy(String type) {
        return this.withReferencePolicy(new TagReferencePolicy(type));
    }

    @Override
    public TagReferenceFluent.ReferencePolicyNested<A> withNewReferencePolicy() {
        return new ReferencePolicyNestedImpl();
    }

    @Override
    public TagReferenceFluent.ReferencePolicyNested<A> withNewReferencePolicyLike(TagReferencePolicy item) {
        return new ReferencePolicyNestedImpl(item);
    }

    @Override
    public TagReferenceFluent.ReferencePolicyNested<A> editReferencePolicy() {
        return this.withNewReferencePolicyLike(this.getReferencePolicy());
    }

    @Override
    public TagReferenceFluent.ReferencePolicyNested<A> editOrNewReferencePolicy() {
        return this.withNewReferencePolicyLike(this.getReferencePolicy() != null ? this.getReferencePolicy() : new TagReferencePolicyBuilder().build());
    }

    @Override
    public TagReferenceFluent.ReferencePolicyNested<A> editOrNewReferencePolicyLike(TagReferencePolicy item) {
        return this.withNewReferencePolicyLike(this.getReferencePolicy() != null ? this.getReferencePolicy() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagReferenceFluentImpl that = (TagReferenceFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) {
            return false;
        }
        if (this.importPolicy != null ? !this.importPolicy.equals(that.importPolicy) : that.importPolicy != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.reference != null ? !this.reference.equals(that.reference) : that.reference != null) {
            return false;
        }
        return !(this.referencePolicy != null ? !this.referencePolicy.equals(that.referencePolicy) : that.referencePolicy != null);
    }

    public class ReferencePolicyNestedImpl<N>
    extends TagReferencePolicyFluentImpl<TagReferenceFluent.ReferencePolicyNested<N>>
    implements TagReferenceFluent.ReferencePolicyNested<N>,
    Nested<N> {
        private final TagReferencePolicyBuilder builder;

        ReferencePolicyNestedImpl(TagReferencePolicy item) {
            this.builder = new TagReferencePolicyBuilder(this, item);
        }

        ReferencePolicyNestedImpl() {
            this.builder = new TagReferencePolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)TagReferenceFluentImpl.this.withReferencePolicy(this.builder.build());
        }

        @Override
        public N endReferencePolicy() {
            return this.and();
        }
    }

    public class ImportPolicyNestedImpl<N>
    extends TagImportPolicyFluentImpl<TagReferenceFluent.ImportPolicyNested<N>>
    implements TagReferenceFluent.ImportPolicyNested<N>,
    Nested<N> {
        private final TagImportPolicyBuilder builder;

        ImportPolicyNestedImpl(TagImportPolicy item) {
            this.builder = new TagImportPolicyBuilder(this, item);
        }

        ImportPolicyNestedImpl() {
            this.builder = new TagImportPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)TagReferenceFluentImpl.this.withImportPolicy(this.builder.build());
        }

        @Override
        public N endImportPolicy() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<TagReferenceFluent.FromNested<N>>
    implements TagReferenceFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)TagReferenceFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

