/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_7;

import io.fabric8.kubernetes.api.model.v4_7.APIGroup;
import io.fabric8.kubernetes.api.model.v4_7.APIGroupList;
import io.fabric8.kubernetes.clnt.v4_7.BaseClient;
import io.fabric8.kubernetes.clnt.v4_7.Client;
import io.fabric8.kubernetes.clnt.v4_7.Config;
import io.fabric8.kubernetes.clnt.v4_7.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_7.utils.Serialization;
import io.fabric8.kubernetes.clnt.v4_7.utils.URLUtils;
import io.fabric8.openshift.clnt.v4_7.OpenShiftConfig;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OpenshiftAdapterSupport {
    static final ConcurrentMap<URL, Boolean> IS_OPENSHIFT = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_OPENSHIFT_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();
    public static final String APIS = "/apis";

    public Boolean isAdaptable(Client client) {
        OpenShiftConfig config = new OpenShiftConfig((Config)client.getConfiguration());
        if (!OpenshiftAdapterSupport.hasCustomOpenShiftUrl(config) && !OpenshiftAdapterSupport.isOpenShift(client)) {
            return false;
        }
        return true;
    }

    static boolean isOpenShift(Client client) {
        return OpenshiftAdapterSupport.isOpenShiftAPIGroups(client);
    }

    static boolean isOpenShiftAPIGroups(Client client) {
        URL masterUrl = client.getMasterUrl();
        OkHttpClient httpClient = ((BaseClient)client).getHttpClient();
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(URLUtils.join(masterUrl.toString(), APIS));
            Response response = httpClient.newCall(requestBuilder.build()).execute();
            APIGroupList apiGroupList = Serialization.unmarshal(response.body().string(), APIGroupList.class);
            for (APIGroup apiGroup : apiGroupList.getGroups()) {
                if (!apiGroup.getName().endsWith("openshift.io")) continue;
                return true;
            }
        }
        catch (Exception e) {
            KubernetesClientException.launderThrowable(e);
        }
        return false;
    }

    static boolean isOpenShiftAPIGroups(OkHttpClient httpClient, String masterUrl) {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(URLUtils.join(masterUrl, APIS));
            Response response = httpClient.newCall(requestBuilder.build()).execute();
            APIGroupList apiGroupList = Serialization.unmarshal(response.body().string(), APIGroupList.class);
            for (APIGroup apiGroup : apiGroupList.getGroups()) {
                if (!apiGroup.getName().endsWith("openshift.io")) continue;
                return true;
            }
        }
        catch (Exception e) {
            KubernetesClientException.launderThrowable(e);
        }
        return false;
    }

    static boolean hasCustomOpenShiftUrl(OpenShiftConfig config) {
        try {
            URI masterUri = new URI(config.getMasterUrl()).resolve("/");
            URI openshfitUri = new URI(config.getOpenShiftUrl()).resolve("/");
            return !masterUri.equals(openshfitUri);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

