/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.handlers;

import io.fabric8.kubernetes.api.model.v4_7.coordination.v1beta1.Lease;
import io.fabric8.kubernetes.api.model.v4_7.coordination.v1beta1.LeaseBuilder;
import io.fabric8.kubernetes.clnt.v4_7.Config;
import io.fabric8.kubernetes.clnt.v4_7.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_7.Watch;
import io.fabric8.kubernetes.clnt.v4_7.Watcher;
import io.fabric8.kubernetes.clnt.v4_7.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_7.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_7.dsl.internal.LeaseOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class LeaseHandler
implements ResourceHandler<Lease, LeaseBuilder> {
    @Override
    public String getKind() {
        return Lease.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "coordination.k8s.io/v1beta1";
    }

    @Override
    public Lease create(OkHttpClient client, Config config, String namespace, Lease item) {
        return (Lease)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Lease[0]);
    }

    @Override
    public Lease replace(OkHttpClient client, Config config, String namespace, Lease item) {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Lease reload(OkHttpClient client, Config config, String namespace, Lease item) {
        return (Lease)((Gettable)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public LeaseBuilder edit(Lease item) {
        return new LeaseBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Lease item) {
        return (Boolean)new LeaseOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Lease item, Watcher<Lease> watcher) {
        return (Watch)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Lease item, String resourceVersion, Watcher<Lease> watcher) {
        return (Watch)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Lease waitUntilReady(OkHttpClient client, Config config, String namespace, Lease item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Lease waitUntilCondition(OkHttpClient client, Config config, String namespace, Lease item, Predicate<Lease> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

